/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.registry;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AppNameUtil;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.function.Supplier;

public final class ConfigSupplierRegistry {
    private static final Supplier<String> DEFAULT_APP_NAME_SUPPLIER = new Supplier<String>(){

        @Override
        public String get() {
            return AppNameUtil.getAppName();
        }
    };
    private static Supplier<String> namespaceSupplier = DEFAULT_APP_NAME_SUPPLIER;

    public static Supplier<String> getNamespaceSupplier() {
        return namespaceSupplier;
    }

    public static void setNamespaceSupplier(Supplier<String> namespaceSupplier) {
        AssertUtil.notNull(namespaceSupplier, "namespaceSupplier cannot be null");
        ConfigSupplierRegistry.namespaceSupplier = namespaceSupplier;
        RecordLog.info("[ConfigSupplierRegistry] New namespace supplier provided, current supplied: {}", namespaceSupplier.get());
    }

    private ConfigSupplierRegistry() {
    }
}

