/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.log.jul;

import com.alibaba.csp.sentinel.log.LogBase;
import com.alibaba.csp.sentinel.log.jul.ConsoleHandler;
import com.alibaba.csp.sentinel.log.jul.CspFormatter;
import com.alibaba.csp.sentinel.log.jul.DateFileLogHandler;
import com.alibaba.csp.sentinel.log.jul.FormattingTuple;
import com.alibaba.csp.sentinel.log.jul.MessageFormatter;
import com.alibaba.csp.sentinel.util.PidUtil;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BaseJulLogger {
    protected void log(Logger logger2, Handler handler, Level level, String detail, Object ... params) {
        if (detail == null) {
            return;
        }
        BaseJulLogger.disableOtherHandlers(logger2, handler);
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(detail, params);
        String message = formattingTuple.getMessage();
        logger2.log(level, message);
    }

    protected void log(Logger logger2, Handler handler, Level level, String detail, Throwable throwable) {
        if (detail == null) {
            return;
        }
        BaseJulLogger.disableOtherHandlers(logger2, handler);
        logger2.log(level, detail, throwable);
    }

    protected Handler makeLoggingHandler(String logName, Logger heliumRecordLog) {
        CspFormatter formatter = new CspFormatter();
        String logCharSet = LogBase.getLogCharset();
        Handler handler = null;
        switch (LogBase.getLogOutputType()) {
            case "file": {
                String fileName = LogBase.getLogBaseDir() + logName;
                if (LogBase.isLogNameUsePid()) {
                    fileName = fileName + ".pid" + PidUtil.getPid();
                }
                try {
                    handler = new DateFileLogHandler(fileName + ".%d", 0xC800000, 4, true);
                    handler.setFormatter(formatter);
                    handler.setEncoding(logCharSet);
                    handler.setLevel(LogBase.getLogLevel());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case "console": {
                try {
                    handler = new ConsoleHandler();
                    handler.setFormatter(formatter);
                    handler.setEncoding(logCharSet);
                    handler.setLevel(LogBase.getLogLevel());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        if (handler != null) {
            BaseJulLogger.disableOtherHandlers(heliumRecordLog, handler);
        }
        heliumRecordLog.setLevel(LogBase.getLogLevel());
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableOtherHandlers(Logger logger2, Handler handler) {
        if (logger2 == null) {
            return;
        }
        Logger logger3 = logger2;
        synchronized (logger3) {
            Handler[] handlers = logger2.getHandlers();
            if (handlers == null) {
                return;
            }
            if (handlers.length == 1 && handlers[0].equals(handler)) {
                return;
            }
            logger2.setUseParentHandlers(false);
            for (Handler h2 : handlers) {
                logger2.removeHandler(h2);
            }
            logger2.addHandler(handler);
        }
    }
}

