/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.heartbeat.client;

import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;

public class SimpleHttpResponseParser {
    private static final int MAX_BODY_SIZE = 0x400000;
    private byte[] buf;

    public SimpleHttpResponseParser(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize must > 0");
        }
        this.buf = new byte[maxSize];
    }

    public SimpleHttpResponseParser() {
        this(4096);
    }

    public SimpleHttpResponse parse(InputStream in) throws IOException {
        int bg = 0;
        String statusLine = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        Charset charset = Charset.forName("utf-8");
        int contentLength = -1;
        while (true) {
            int idx;
            if (bg >= this.buf.length) {
                throw new IndexOutOfBoundsException("buf index out of range: " + bg + ", buf.length=" + this.buf.length);
            }
            int len = in.read(this.buf, bg, this.buf.length - bg);
            if (len <= 0) break;
            bg += len;
            len = bg;
            int parseBg = 0;
            while ((idx = this.indexOfCRLF(parseBg, len)) >= 0) {
                String line = new String(this.buf, parseBg, idx - parseBg, charset);
                parseBg = idx + 2;
                if (statusLine == null) {
                    statusLine = line;
                    continue;
                }
                if (line.isEmpty()) {
                    SimpleHttpResponse response = new SimpleHttpResponse(statusLine, headers);
                    if (contentLength <= 0) {
                        return response;
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                    if (contentLength < len - parseBg) {
                        throw new IllegalStateException("Invalid content length: " + contentLength);
                    }
                    out.write(this.buf, parseBg, len - parseBg);
                    if (out.size() > 0x400000) {
                        throw new IllegalStateException("Request body is too big, limit size is 4194304");
                    }
                    int cap = Math.min(contentLength - out.size(), this.buf.length);
                    while (cap > 0 && (len = in.read(this.buf, 0, cap)) > 0) {
                        out.write(this.buf, 0, len);
                        cap = Math.min(contentLength - out.size(), this.buf.length);
                    }
                    response.setBody(out.toByteArray());
                    return response;
                }
                if (line.trim().isEmpty()) continue;
                int idx2 = line.indexOf(":");
                String key = line.substring(0, idx2).trim();
                String value = line.substring(idx2 + 1).trim();
                headers.put(key, value);
                if (!"Content-Length".equalsIgnoreCase(key)) continue;
                contentLength = Integer.parseInt(value);
            }
            if (parseBg != 0) {
                System.arraycopy(this.buf, parseBg, this.buf, 0, len - parseBg);
            }
            bg = len - parseBg;
        }
        return null;
    }

    private int indexOfCRLF(int bg, int ed) {
        if (ed - bg < 2) {
            return -1;
        }
        for (int i2 = bg; i2 < ed - 1; ++i2) {
            if (this.buf[i2] != 13 || this.buf[i2 + 1] != 10) continue;
            return i2;
        }
        return -1;
    }
}

