/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.param;

import com.alibaba.nacos.common.utils.StringUtils;

public final class MediaType {
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded;charset=UTF-8";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_SVG_XML = "application/svg+xml";
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final String APPLICATION_XML = "application/xml;charset=UTF-8";
    public static final String APPLICATION_JSON = "application/json;charset=UTF-8";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data;charset=UTF-8";
    public static final String TEXT_HTML = "text/html;charset=UTF-8";
    public static final String TEXT_PLAIN = "text/plain;charset=UTF-8";
    private final String type;
    private final String charset;

    private MediaType(String type, String charset) {
        this.type = type;
        this.charset = charset;
    }

    public static MediaType valueOf(String contentType) {
        if (StringUtils.isEmpty(contentType)) {
            throw new IllegalArgumentException("MediaType must not be empty");
        }
        String[] values2 = contentType.split(";");
        String charset = "UTF-8";
        for (String value : values2) {
            if (!value.startsWith("charset=")) continue;
            charset = value.substring("charset=".length());
        }
        return new MediaType(values2[0], charset);
    }

    public static MediaType valueOf(String contentType, String charset) {
        if (StringUtils.isEmpty(contentType)) {
            throw new IllegalArgumentException("MediaType must not be empty");
        }
        String[] values2 = contentType.split(";");
        return new MediaType(values2[0], StringUtils.isEmpty(charset) ? "UTF-8" : charset);
    }

    public String getType() {
        return this.type;
    }

    public String getCharset() {
        return this.charset;
    }

    public String toString() {
        return this.type + ";charset=" + this.charset;
    }
}

