/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CollectionUtils {
    public static Object get(Object object, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative: " + index);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterator iterator2 = map.entrySet().iterator();
            return CollectionUtils.get(iterator2, index);
        }
        if (object instanceof List) {
            return ((List)object).get(index);
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[index];
        }
        if (object instanceof Iterator) {
            Iterator it = (Iterator)object;
            while (it.hasNext()) {
                if (--index == -1) {
                    return it.next();
                }
                it.next();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index);
        }
        if (object instanceof Collection) {
            Iterator iterator3 = ((Collection)object).iterator();
            return CollectionUtils.get(iterator3, index);
        }
        if (object instanceof Enumeration) {
            Enumeration it = (Enumeration)object;
            while (it.hasMoreElements()) {
                if (--index == -1) {
                    return it.nextElement();
                }
                it.nextElement();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index);
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.get(object, index);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public static int size(Object object) {
        int total = 0;
        if (object instanceof Map) {
            total = ((Map)object).size();
        } else if (object instanceof Collection) {
            total = ((Collection)object).size();
        } else if (object instanceof Object[]) {
            total = ((Object[])object).length;
        } else if (object instanceof Iterator) {
            Iterator it = (Iterator)object;
            while (it.hasNext()) {
                ++total;
                it.next();
            }
        } else if (object instanceof Enumeration) {
            Enumeration it = (Enumeration)object;
            while (it.hasMoreElements()) {
                ++total;
                it.nextElement();
            }
        } else {
            if (object == null) {
                throw new IllegalArgumentException("Unsupported object type: null");
            }
            try {
                total = Array.getLength(object);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
            }
        }
        return total;
    }

    public static boolean sizeIsEmpty(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Iterator) {
            return !((Iterator)object).hasNext();
        }
        if (object instanceof Enumeration) {
            return !((Enumeration)object).hasMoreElements();
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.getLength(object) == 0;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public static <T> boolean contains(Collection<T> coll, T target) {
        if (CollectionUtils.isEmpty(coll)) {
            return false;
        }
        return coll.contains(target);
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection coll) {
        return !CollectionUtils.isEmpty(coll);
    }

    public static <T> T getOrDefault(Collection<T> coll, int index, T defaultValue) {
        try {
            return (T)CollectionUtils.get(coll, index);
        }
        catch (IndexOutOfBoundsException e) {
            return defaultValue;
        }
    }
}

