/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.console;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import common.config.tools.config.ConfigTools3;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ConfigToolsConsole3 {
    public static void main(String[] args2) throws IOException {
        Options options = new Options();
        options.addOption(Option.builder().required(false).longOpt("help").desc("Show this help information").build());
        options.addOption(Option.builder().required(false).longOpt("key").desc("Config key").hasArg().build());
        options.addOption(Option.builder().required(false).longOpt("path").desc("config path").hasArg().build());
        options.addOption(Option.builder().required(false).longOpt("ext").desc("config file extension").hasArg().build());
        String key = "";
        String ext = "";
        String path = "";
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmd = parser.parse(options, args2);
            if (cmd.hasOption("help")) {
                new HelpFormatter().printHelp("java -jar config-tools-console.jar", options);
                System.exit(0);
            }
            path = cmd.getOptionValue("path");
            key = cmd.getOptionValue("key");
            ext = cmd.getOptionValue("ext");
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            return;
        }
        List<Object> exts = Lists.newArrayList();
        if (!Strings.isNullOrEmpty(ext)) {
            exts = Splitter.on(",").trimResults().splitToList(ext);
        }
        System.out.println("*** For help please use : java -jar config-tools-console.jar --help");
        ConfigTools3.enableEnv(true);
        if (!Strings.isNullOrEmpty(path)) {
            if (exts.isEmpty()) {
                System.out.println("Load directory:" + path);
                ConfigTools3.load(path);
            } else {
                System.out.println("Load directory:" + path + " ext:" + ext);
                ConfigTools3.load(path, Sets.newHashSet(exts));
            }
        } else {
            System.out.println("Load directory:./config");
            ConfigTools3.load();
        }
        System.out.println("********************************************");
        if (!Strings.isNullOrEmpty(key)) {
            String value = ConfigTools3.getString(key);
            System.out.println(key + "=" + value);
        } else {
            ConfigTools3.getAllConfig().forEach((k, v) -> System.out.println(k + "=" + v));
        }
        System.exit(0);
    }
}

