/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.file.monitor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import common.config.tools.file.monitor.IFileChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMonitor {
    private static final Logger logger = LoggerFactory.getLogger(FileMonitor.class);
    private FileAlterationMonitor monitor;
    private long interval = 0L;
    private Map<String, FileAlterationObserver> directoryObserverMap = Maps.newLinkedHashMap();

    public FileMonitor(long interval) {
        this.interval = interval;
        if (this.interval > 0L) {
            if (this.interval < 1000L) {
                this.interval = 1000L;
            }
            this.monitor = new FileAlterationMonitor(interval);
        } else {
            this.monitor = new FileAlterationMonitor(600000L);
        }
    }

    public FileMonitor addDirectoryListener(String filePath, Set<String> fileExt, IFileChangeListener listener) {
        return this.addDirectoryListener(filePath, fileExt, listener, false);
    }

    public FileMonitor addDirectoryListener(String filePath, Set<String> fileExt, IFileChangeListener listener, boolean recursive) {
        return this.addDirectoryListener(filePath, new SuffixFileFilter(Lists.newArrayList(fileExt), IOCase.INSENSITIVE), listener, recursive);
    }

    public FileMonitor addDirectoryListener(String filePath, IOFileFilter filter2, IFileChangeListener listener, boolean recursive) {
        File rootDir = FileUtils.getFile(filePath);
        if (!rootDir.isDirectory() || !rootDir.exists()) {
            logger.warn("File [{}] is not Directory or not Exist.", (Object)rootDir);
            return this;
        }
        IOFileFilter fileFilter = null;
        fileFilter = filter2 == null ? FileFilterUtils.fileFileFilter() : filter2;
        this.loadOnStartup(listener, rootDir, fileFilter, recursive);
        if (this.interval > 0L) {
            FileAlterationObserver observer = this.getFileAlterationObserver(rootDir, fileFilter, listener);
            this.monitor.addObserver(observer);
            this.directoryObserverMap.put(rootDir.getAbsolutePath(), observer);
            logger.info("Add directory[{}] to monitor.", (Object)rootDir.getAbsolutePath());
            if (recursive) {
                this.addSubDirectoryObserver(rootDir, fileFilter, listener);
            }
        }
        return this;
    }

    private void addSubDirectoryObserver(File rootPath, IOFileFilter fileFilter, IFileChangeListener listener) {
        Collection<File> files = FileUtils.listFilesAndDirs(rootPath, FileFilterUtils.directoryFileFilter(), FileFilterUtils.directoryFileFilter());
        if (files != null && files.size() > 0) {
            for (File f : files) {
                if (!f.isDirectory() || FilenameUtils.equals(rootPath.getAbsolutePath(), f.getAbsolutePath()) || this.directoryObserverMap.containsKey(f.getAbsolutePath())) continue;
                FileAlterationObserver observer = this.getFileAlterationObserver(f, fileFilter, listener);
                this.monitor.addObserver(observer);
                this.directoryObserverMap.put(f.getAbsolutePath(), observer);
                logger.info("Add dir[{}] to monitor.", (Object)f.getAbsolutePath());
            }
        }
    }

    private FileAlterationObserver getFileAlterationObserverDirAdd(File rootPath, final IOFileFilter fileFilter, final IFileChangeListener listener) {
        FileAlterationObserver dirChanged = new FileAlterationObserver(rootPath, (FileFilter)FileFilterUtils.directoryFileFilter());
        dirChanged.addListener(new FileAlterationListenerAdaptor(){

            @Override
            public void onDirectoryChange(File directory) {
                FileMonitor.this.addSubDirectoryObserver(directory, fileFilter, listener);
            }

            @Override
            public void onDirectoryDelete(File directory) {
                FileAlterationObserver observer = (FileAlterationObserver)FileMonitor.this.directoryObserverMap.get(directory.getAbsolutePath());
                if (observer != null) {
                    FileMonitor.this.monitor.removeObserver(observer);
                }
            }
        });
        return dirChanged;
    }

    private void loadOnStartup(IFileChangeListener listener, File rootPath, IOFileFilter fileFilter, boolean recursive) {
        Collection<Object> files = Collections.EMPTY_SET;
        files = recursive ? FileUtils.listFiles(rootPath, fileFilter, FileFilterUtils.directoryFileFilter()) : FileUtils.listFiles(rootPath, fileFilter, null);
        if (files != null) {
            files.forEach(e -> listener.onFileChange((File)e));
        }
    }

    private FileAlterationObserver getFileAlterationObserver(File rootPath, IOFileFilter fileFilter, IFileChangeListener listener) {
        FileAlterationObserver observer = new FileAlterationObserver(rootPath, (FileFilter)fileFilter);
        observer.addListener(listener);
        return observer;
    }

    public void start() {
        try {
            this.monitor.start();
        }
        catch (Exception e) {
            logger.info("Start exception:{}", e);
        }
    }

    public void stop() {
        try {
            this.monitor.stop();
        }
        catch (Exception e) {
            logger.info("Stop exception:{}", e);
        }
    }
}

