/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.file.monitor;

import com.google.common.collect.Maps;
import common.config.tools.config.loader.properties.PropertiesLoader;
import common.config.tools.file.monitor.FileChangeListenerAdaptor;
import common.config.tools.model.ConfigValueDTO;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileListener
extends FileChangeListenerAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFileListener.class);
    private Map<String, ConfigValueDTO> properties = Maps.newLinkedHashMap();

    public PropertyFileListener(boolean backupAfterProcess, Map<String, ConfigValueDTO> properties) {
        super(backupAfterProcess);
        this.properties = properties;
    }

    @Override
    public void onFileCreate(File file) {
        logger.info("Property Config File Create:[{}]", (Object)file.getAbsolutePath());
        this.loadProperty(file);
    }

    @Override
    public void onFileChange(File file) {
        logger.info("Property Config File Changed:[{}]", (Object)file.getAbsolutePath());
        this.loadProperty(file);
    }

    @Override
    public void onFileDelete(File file) {
        logger.info("Property Config File Delete:[{}]", (Object)file.getAbsolutePath());
    }

    private void loadProperty(File file) {
        try {
            Map<String, String> propertyMap = PropertiesLoader.loader(file);
            propertyMap.forEach((k, v) -> {
                if (this.properties.containsKey(k)) {
                    ConfigValueDTO oldValue = this.properties.get(k);
                    if (!oldValue.contentEquals((String)v)) {
                        this.properties.put((String)k, ConfigValueDTO.valueOf(v));
                        logger.info("property modify:key[{}] value[{}]->[{}]", k, oldValue, v);
                    }
                } else {
                    logger.info("property load:key[{}] value[{}]", k, v);
                    this.properties.put((String)k, ConfigValueDTO.valueOf(v));
                }
            });
        }
        catch (IOException e) {
            logger.info("Load properties[{}] exception:{}", (Object)file.getAbsolutePath(), (Object)e);
        }
    }
}

