/*
 * Decompiled with CFR 0.152.
 */
package common.log.filter;

import com.google.common.base.Strings;
import common.log.filter.HttpTools;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class MDCServletFilter
implements Filter {
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.insertIntoMDC(request);
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.clearMDC();
        }
    }

    @Override
    public void destroy() {
    }

    private void insertIntoMDC(ServletRequest request) {
        MDC.put("sessionId", this.getSessionId((HttpServletRequest)request));
        MDC.put("clientIp", HttpTools.getClientIp((HttpServletRequest)request));
        MDC.put("accountId", this.getAccountId((HttpServletRequest)request));
        MDC.put("accountName", this.getAccountName((HttpServletRequest)request));
    }

    private void clearMDC() {
        MDC.remove("sessionId");
        MDC.remove("clientIp");
        MDC.remove("accountId");
        MDC.remove("accountName");
    }

    private String getSessionId(HttpServletRequest request) {
        return HttpTools.getHttpParameter(request, "sessionId");
    }

    private String getAccountId(HttpServletRequest request) {
        String value = HttpTools.getHttpParameter(request, "accountId");
        if (!Strings.isNullOrEmpty(value)) {
            return value;
        }
        value = HttpTools.getHttpParameter(request, "uid");
        if (!Strings.isNullOrEmpty(value)) {
            return value;
        }
        return "";
    }

    private String getAccountName(HttpServletRequest request) {
        String value = HttpTools.getHttpParameter(request, "accountName");
        if (!Strings.isNullOrEmpty(value)) {
            return value;
        }
        value = HttpTools.getHttpParameter(request, "mac");
        if (!Strings.isNullOrEmpty(value)) {
            return value;
        }
        value = HttpTools.getHttpParameter(request, "did");
        if (!Strings.isNullOrEmpty(value)) {
            return value;
        }
        return "";
    }
}

