/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayDeque;
import java.util.Deque;

public class QueryParameterAttribute
implements ExchangeAttribute {
    private final String parameter;

    public QueryParameterAttribute(String parameter) {
        this.parameter = parameter;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        Deque<String> res = exchange2.getQueryParameters().get(this.parameter);
        if (res == null) {
            return null;
        }
        if (res.isEmpty()) {
            return "";
        }
        if (res.size() == 1) {
            return res.getFirst();
        }
        StringBuilder sb = new StringBuilder("[");
        int i2 = 0;
        for (String s2 : res) {
            sb.append(s2);
            if (++i2 == res.size()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        ArrayDeque<String> value = new ArrayDeque<String>();
        value.add(newValue);
        exchange2.getQueryParameters().put(this.parameter, value);
    }

    public String toString() {
        return "%{q," + this.parameter + "}";
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Query Parameter";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{q,") && token.endsWith("}")) {
                String qp = token.substring(4, token.length() - 1);
                return new QueryParameterAttribute(qp);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

