/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;

public class ResponseCookieAttribute
implements ExchangeAttribute {
    private static final String TOKEN_PREFIX = "%{resp-cookie,";
    private final String cookieName;

    public ResponseCookieAttribute(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        for (Cookie cookie : exchange2.responseCookies()) {
            if (!this.cookieName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        exchange2.setResponseCookie(new CookieImpl(this.cookieName, newValue));
    }

    public String toString() {
        return TOKEN_PREFIX + this.cookieName + "}";
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response cookie";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith(ResponseCookieAttribute.TOKEN_PREFIX) && token.endsWith("}")) {
                String cookieName = token.substring(ResponseCookieAttribute.TOKEN_PREFIX.length(), token.length() - 1);
                return new ResponseCookieAttribute(cookieName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

