/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.UndertowMessages;
import io.undertow.protocols.http2.HPackHuffman;
import io.undertow.protocols.http2.Hpack;
import io.undertow.protocols.http2.HpackException;
import io.undertow.util.HttpString;
import java.nio.ByteBuffer;

public class HpackDecoder {
    private static final int DEFAULT_RING_BUFFER_SIZE = 10;
    private HeaderEmitter headerEmitter;
    private Hpack.HeaderField[] headerTable;
    private int firstSlotPosition = 0;
    private int filledTableSlots = 0;
    private int currentMemorySize = 0;
    private int specifiedMemorySize;
    private final int maxAllowedMemorySize;
    private boolean first = true;
    private final StringBuilder stringBuilder = new StringBuilder();

    public HpackDecoder(int maxAllowedMemorySize) {
        this.specifiedMemorySize = Math.min(4096, maxAllowedMemorySize);
        this.maxAllowedMemorySize = maxAllowedMemorySize;
        this.headerTable = new Hpack.HeaderField[10];
    }

    public HpackDecoder() {
        this(4096);
    }

    public void decode(ByteBuffer buffer, boolean moreData) throws HpackException {
        while (buffer.hasRemaining()) {
            String headerValue;
            int originalPos = buffer.position();
            byte b = buffer.get();
            if ((b & 0x80) != 0) {
                this.first = false;
                buffer.position(buffer.position() - 1);
                int index = Hpack.decodeInteger(buffer, 7);
                if (index == -1) {
                    if (!moreData) {
                        throw UndertowMessages.MESSAGES.hpackFailed();
                    }
                    buffer.position(originalPos);
                    return;
                }
                if (index == 0) {
                    throw UndertowMessages.MESSAGES.zeroNotValidHeaderTableIndex();
                }
                this.handleIndex(index);
                continue;
            }
            if ((b & 0x40) != 0) {
                this.first = false;
                HttpString headerName = this.readHeaderName(buffer, 6);
                if (headerName == null) {
                    if (!moreData) {
                        throw UndertowMessages.MESSAGES.hpackFailed();
                    }
                    buffer.position(originalPos);
                    return;
                }
                headerValue = this.readHpackString(buffer);
                if (headerValue == null) {
                    if (!moreData) {
                        throw UndertowMessages.MESSAGES.hpackFailed();
                    }
                    buffer.position(originalPos);
                    return;
                }
                this.headerEmitter.emitHeader(headerName, headerValue, false);
                this.addEntryToHeaderTable(new Hpack.HeaderField(headerName, headerValue));
                continue;
            }
            if ((b & 0xF0) == 0) {
                this.first = false;
                HttpString headerName = this.readHeaderName(buffer, 4);
                if (headerName == null) {
                    if (!moreData) {
                        throw UndertowMessages.MESSAGES.hpackFailed();
                    }
                    buffer.position(originalPos);
                    return;
                }
                headerValue = this.readHpackString(buffer);
                if (headerValue == null) {
                    if (!moreData) {
                        throw UndertowMessages.MESSAGES.hpackFailed();
                    }
                    buffer.position(originalPos);
                    return;
                }
                this.headerEmitter.emitHeader(headerName, headerValue, false);
                continue;
            }
            if ((b & 0xF0) == 16) {
                this.first = false;
                HttpString headerName = this.readHeaderName(buffer, 4);
                if (headerName == null) {
                    buffer.position(originalPos);
                    return;
                }
                headerValue = this.readHpackString(buffer);
                if (headerValue == null) {
                    if (!moreData) {
                        throw UndertowMessages.MESSAGES.hpackFailed();
                    }
                    buffer.position(originalPos);
                    return;
                }
                this.headerEmitter.emitHeader(headerName, headerValue, true);
                continue;
            }
            if ((b & 0xE0) == 32) {
                if (!this.first) {
                    throw new HpackException();
                }
                if (this.handleMaxMemorySizeChange(buffer, originalPos)) continue;
                return;
            }
            throw UndertowMessages.MESSAGES.invalidHpackEncoding(b);
        }
        if (!moreData) {
            this.first = true;
        }
    }

    private boolean handleMaxMemorySizeChange(ByteBuffer buffer, int originalPos) throws HpackException {
        buffer.position(buffer.position() - 1);
        int size = Hpack.decodeInteger(buffer, 5);
        if (size == -1) {
            buffer.position(originalPos);
            return false;
        }
        if (size > this.maxAllowedMemorySize) {
            throw new HpackException(1);
        }
        this.specifiedMemorySize = size;
        if (this.currentMemorySize > this.specifiedMemorySize) {
            int newTableSlots = this.filledTableSlots;
            int tableLength = this.headerTable.length;
            int newSize = this.currentMemorySize;
            while (newSize > this.specifiedMemorySize) {
                int clearIndex = this.firstSlotPosition++;
                if (this.firstSlotPosition == tableLength) {
                    this.firstSlotPosition = 0;
                }
                Hpack.HeaderField oldData = this.headerTable[clearIndex];
                this.headerTable[clearIndex] = null;
                newSize -= oldData.size;
                --newTableSlots;
            }
            this.filledTableSlots = newTableSlots;
            this.currentMemorySize = newSize;
        }
        return true;
    }

    private HttpString readHeaderName(ByteBuffer buffer, int prefixLength) throws HpackException {
        buffer.position(buffer.position() - 1);
        int index = Hpack.decodeInteger(buffer, prefixLength);
        if (index == -1) {
            return null;
        }
        if (index != 0) {
            return this.handleIndexedHeaderName(index);
        }
        String string = this.readHpackString(buffer);
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            throw new HpackException();
        }
        return new HttpString(string);
    }

    private String readHpackString(ByteBuffer buffer) throws HpackException {
        boolean huffman;
        if (!buffer.hasRemaining()) {
            return null;
        }
        byte data = buffer.get(buffer.position());
        int length = Hpack.decodeInteger(buffer, 7);
        if (buffer.remaining() < length || length == -1) {
            return null;
        }
        boolean bl = huffman = (data & 0x80) != 0;
        if (huffman) {
            return this.readHuffmanString(length, buffer);
        }
        for (int i2 = 0; i2 < length; ++i2) {
            this.stringBuilder.append((char)buffer.get());
        }
        String ret = this.stringBuilder.toString();
        this.stringBuilder.setLength(0);
        if (ret.isEmpty()) {
            return "";
        }
        return ret;
    }

    private String readHuffmanString(int length, ByteBuffer buffer) throws HpackException {
        HPackHuffman.decode(buffer, length, this.stringBuilder);
        String ret = this.stringBuilder.toString();
        if (ret.isEmpty()) {
            return "";
        }
        this.stringBuilder.setLength(0);
        return ret;
    }

    private HttpString handleIndexedHeaderName(int index) throws HpackException {
        if (index <= Hpack.STATIC_TABLE_LENGTH) {
            return Hpack.STATIC_TABLE[index].name;
        }
        if (index > Hpack.STATIC_TABLE_LENGTH + this.filledTableSlots) {
            throw new HpackException();
        }
        int adjustedIndex = this.getRealIndex(index - Hpack.STATIC_TABLE_LENGTH);
        Hpack.HeaderField res = this.headerTable[adjustedIndex];
        if (res == null) {
            throw new HpackException();
        }
        return res.name;
    }

    private void handleIndex(int index) throws HpackException {
        if (index <= Hpack.STATIC_TABLE_LENGTH) {
            this.addStaticTableEntry(index);
        } else {
            int adjustedIndex = this.getRealIndex(index - Hpack.STATIC_TABLE_LENGTH);
            Hpack.HeaderField headerField = this.headerTable[adjustedIndex];
            this.headerEmitter.emitHeader(headerField.name, headerField.value, false);
        }
    }

    int getRealIndex(int index) throws HpackException {
        int newIndex = (this.firstSlotPosition + (this.filledTableSlots - index)) % this.headerTable.length;
        if (newIndex < 0) {
            throw UndertowMessages.MESSAGES.invalidHpackIndex(index);
        }
        return newIndex;
    }

    private void addStaticTableEntry(int index) throws HpackException {
        Hpack.HeaderField entry = Hpack.STATIC_TABLE[index];
        this.headerEmitter.emitHeader(entry.name, entry.value == null ? "" : entry.value, false);
    }

    private void addEntryToHeaderTable(Hpack.HeaderField entry) {
        if (entry.size > this.specifiedMemorySize) {
            while (this.filledTableSlots > 0) {
                this.headerTable[this.firstSlotPosition] = null;
                ++this.firstSlotPosition;
                if (this.firstSlotPosition == this.headerTable.length) {
                    this.firstSlotPosition = 0;
                }
                --this.filledTableSlots;
            }
            this.currentMemorySize = 0;
            return;
        }
        this.resizeIfRequired();
        int newTableSlots = this.filledTableSlots + 1;
        int tableLength = this.headerTable.length;
        int index = (this.firstSlotPosition + this.filledTableSlots) % tableLength;
        this.headerTable[index] = entry;
        int newSize = this.currentMemorySize + entry.size;
        while (newSize > this.specifiedMemorySize) {
            int clearIndex = this.firstSlotPosition++;
            if (this.firstSlotPosition == tableLength) {
                this.firstSlotPosition = 0;
            }
            Hpack.HeaderField oldData = this.headerTable[clearIndex];
            this.headerTable[clearIndex] = null;
            newSize -= oldData.size;
            --newTableSlots;
        }
        this.filledTableSlots = newTableSlots;
        this.currentMemorySize = newSize;
    }

    private void resizeIfRequired() {
        if (this.filledTableSlots == this.headerTable.length) {
            Hpack.HeaderField[] newArray = new Hpack.HeaderField[this.headerTable.length + 10];
            for (int i2 = 0; i2 < this.headerTable.length; ++i2) {
                newArray[i2] = this.headerTable[(this.firstSlotPosition + i2) % this.headerTable.length];
            }
            this.firstSlotPosition = 0;
            this.headerTable = newArray;
        }
    }

    public HeaderEmitter getHeaderEmitter() {
        return this.headerEmitter;
    }

    public void setHeaderEmitter(HeaderEmitter headerEmitter) {
        this.headerEmitter = headerEmitter;
    }

    int getFirstSlotPosition() {
        return this.firstSlotPosition;
    }

    Hpack.HeaderField[] getHeaderTable() {
        return this.headerTable;
    }

    int getFilledTableSlots() {
        return this.filledTableSlots;
    }

    int getCurrentMemorySize() {
        return this.currentMemorySize;
    }

    int getSpecifiedMemorySize() {
        return this.specifiedMemorySize;
    }

    public static interface HeaderEmitter {
        public void emitHeader(HttpString var1, String var2, boolean var3) throws HpackException;
    }
}

