/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class AbstractConfidentialityHandler
implements HttpHandler {
    private final HttpHandler next;

    protected AbstractConfidentialityHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        if (this.isConfidential(exchange2) || !this.confidentialityRequired(exchange2)) {
            this.next.handleRequest(exchange2);
        } else {
            try {
                URI redirectUri = this.getRedirectURI(exchange2);
                UndertowLogger.SECURITY_LOGGER.debugf("Redirecting request %s to %s to meet confidentiality requirements", (Object)exchange2, (Object)redirectUri);
                exchange2.setStatusCode(302);
                exchange2.getResponseHeaders().put(Headers.LOCATION, redirectUri.toString());
            }
            catch (Exception e) {
                UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(e);
                exchange2.setStatusCode(500);
            }
            exchange2.endExchange();
        }
    }

    protected boolean isConfidential(HttpServerExchange exchange2) {
        return exchange2.getRequestScheme().equals("https");
    }

    protected boolean confidentialityRequired(HttpServerExchange exchange2) {
        return true;
    }

    protected abstract URI getRedirectURI(HttpServerExchange var1) throws URISyntaxException;
}

