/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.handlers.Cookie;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

final class MapDelegatingToSet
extends HashMap<String, Cookie> {
    private final Set<Cookie> delegate;

    MapDelegatingToSet(Set<Cookie> delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Cookie get(Object key) {
        if (key == null) {
            return null;
        }
        for (Cookie cookie : this.delegate) {
            if (!key.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        for (Cookie cookie : this.delegate) {
            if (!key.equals(cookie.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Cookie put(String key, Cookie value) {
        if (key == null) {
            return null;
        }
        Cookie retVal = this.remove(key);
        if (value != null) {
            this.delegate.add(value);
        }
        return retVal;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Cookie> m3) {
        if (m3 == null) {
            return;
        }
        for (Map.Entry<? extends String, ? extends Cookie> entry : m3.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Cookie remove(Object key) {
        if (key == null) {
            return null;
        }
        Cookie removedValue = null;
        for (Cookie cookie : this.delegate) {
            if (!key.equals(cookie.getName())) continue;
            removedValue = cookie;
            break;
        }
        if (removedValue != null) {
            this.delegate.remove(removedValue);
        }
        return removedValue;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        return this.delegate.contains(value);
    }

    @Override
    public Set<String> keySet() {
        if (this.delegate.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> retVal = new HashSet<String>();
        for (Cookie cookie : this.delegate) {
            retVal.add(cookie.getName());
        }
        return Collections.unmodifiableSet(retVal);
    }

    @Override
    public Collection<Cookie> values() {
        return this.delegate.isEmpty() ? Collections.emptySet() : Collections.unmodifiableCollection(this.delegate);
    }

    @Override
    public Set<Map.Entry<String, Cookie>> entrySet() {
        if (this.delegate.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ReadOnlyEntry> retVal = new HashSet<ReadOnlyEntry>(this.delegate.size());
        for (Cookie cookie : this.delegate) {
            retVal.add(new ReadOnlyEntry(cookie.getName(), cookie));
        }
        return Collections.unmodifiableSet(retVal);
    }

    @Override
    public Cookie getOrDefault(Object key, Cookie defaultValue) {
        if (key == null) {
            return null;
        }
        Cookie retVal = this.get(key);
        return retVal != null ? retVal : defaultValue;
    }

    @Override
    public Cookie putIfAbsent(String key, Cookie value) {
        if (key == null) {
            return null;
        }
        Cookie oldVal = this.get(key);
        if (oldVal == null) {
            this.delegate.add(value);
        }
        return oldVal;
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null || value == null) {
            return false;
        }
        Cookie removedValue = null;
        for (Cookie cookie : this.delegate) {
            if (cookie != value) continue;
            removedValue = cookie;
            break;
        }
        if (removedValue != null) {
            this.delegate.remove(removedValue);
        }
        return removedValue != null;
    }

    @Override
    public boolean replace(String key, Cookie oldValue, Cookie newValue) {
        if (key == null) {
            return false;
        }
        Cookie previousValue = this.get(key);
        if (previousValue == oldValue) {
            this.delegate.remove(oldValue);
            if (newValue != null) {
                this.delegate.add(newValue);
            }
            return true;
        }
        return false;
    }

    @Override
    public Cookie replace(String key, Cookie value) {
        if (key == null) {
            return null;
        }
        Cookie oldValue = this.get(key);
        if (oldValue != null) {
            this.delegate.remove(oldValue);
            if (value != null) {
                this.delegate.add(value);
            }
        }
        return oldValue;
    }

    @Override
    public Cookie computeIfAbsent(String key, Function<? super String, ? extends Cookie> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cookie computeIfPresent(String key, BiFunction<? super String, ? super Cookie, ? extends Cookie> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cookie compute(String key, BiFunction<? super String, ? super Cookie, ? extends Cookie> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cookie merge(String key, Cookie value, BiFunction<? super Cookie, ? super Cookie, ? extends Cookie> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Cookie> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Cookie, ? extends Cookie> function) {
        throw new UnsupportedOperationException();
    }

    private static final class ReadOnlyEntry
    implements Map.Entry<String, Cookie> {
        private final String key;
        private final Cookie value;

        private ReadOnlyEntry(String key, Cookie value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Cookie getValue() {
            return this.value;
        }

        @Override
        public Cookie setValue(Cookie cookie) {
            throw new UnsupportedOperationException();
        }
    }
}

