/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

public enum CookieSameSiteMode {
    STRICT("Strict"),
    LAX("Lax"),
    NONE("None");

    private static final CookieSameSiteMode[] SAMESITE_MODES;
    private final String label;

    private CookieSameSiteMode(String label) {
        this.label = label;
    }

    public static String lookupModeString(String mode) {
        for (CookieSameSiteMode m3 : SAMESITE_MODES) {
            if (!m3.name().equalsIgnoreCase(mode)) continue;
            return m3.toString();
        }
        return null;
    }

    public String toString() {
        return this.label;
    }

    static {
        SAMESITE_MODES = CookieSameSiteMode.values();
    }
}

