/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.server.protocol.http.HttpContinue;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class HttpContinueAcceptingHandler
implements HttpHandler {
    private final HttpHandler next;
    private final Predicate accept;

    public HttpContinueAcceptingHandler(HttpHandler next, Predicate accept) {
        this.next = next;
        this.accept = accept;
    }

    public HttpContinueAcceptingHandler(HttpHandler next) {
        this(next, Predicates.truePredicate());
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        if (HttpContinue.requiresContinueResponse(exchange2)) {
            if (this.accept.resolve(exchange2)) {
                HttpContinue.sendContinueResponse(exchange2, new IoCallback(){

                    @Override
                    public void onComplete(HttpServerExchange exchange2, Sender sender) {
                        exchange2.dispatch(HttpContinueAcceptingHandler.this.next);
                    }

                    @Override
                    public void onException(HttpServerExchange exchange2, Sender sender, IOException exception) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                        exchange2.endExchange();
                    }
                });
            } else {
                HttpContinue.rejectExchange(exchange2);
            }
        } else {
            this.next.handleRequest(exchange2);
        }
    }

    public String toString() {
        return "http-continue-accept()";
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "http-continue-accept";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return null;
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper(Predicates.truePredicate());
        }
    }

    public static final class Wrapper
    implements HandlerWrapper {
        private final Predicate predicate;

        public Wrapper(Predicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new HttpContinueAcceptingHandler(handler, this.predicate);
        }
    }
}

