/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class ServletRequestedSessionIdFromCookieAttribute
implements ExchangeAttribute {
    public static final String REQUESTED_SESSION_ID_FROM_COOKIE = "%{REQUESTED_SESSION_ID_FROM_COOKIE}";
    public static final ServletRequestedSessionIdFromCookieAttribute INSTANCE = new ServletRequestedSessionIdFromCookieAttribute();

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        ServletRequest req;
        ServletRequestContext context = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (context != null && (req = context.getServletRequest()) instanceof HttpServletRequest) {
            return Boolean.toString(((HttpServletRequest)req).isRequestedSessionIdFromCookie());
        }
        return null;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Requested session ID from cookie", newValue);
    }

    public String toString() {
        return REQUESTED_SESSION_ID_FROM_COOKIE;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Requested Session ID from cookie attribute";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ServletRequestedSessionIdFromCookieAttribute.REQUESTED_SESSION_ID_FROM_COOKIE)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

