/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.SecurityActions;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import java.security.AccessController;
import java.util.HashSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class SessionListenerBridge
implements SessionListener {
    public static final String IO_UNDERTOW = "io.undertow";
    private final ApplicationListeners applicationListeners;
    private final ServletContext servletContext;
    private final ThreadSetupHandler.Action<Void, Session> destroyedAction;

    public SessionListenerBridge(Deployment deployment, ApplicationListeners applicationListeners, ServletContext servletContext) {
        this.applicationListeners = applicationListeners;
        this.servletContext = servletContext;
        this.destroyedAction = deployment.createThreadSetupAction(new ThreadSetupHandler.Action<Void, Session>(){

            @Override
            public Void call(HttpServerExchange exchange2, Session session) throws ServletException {
                SessionListenerBridge.this.doDestroy(session);
                return null;
            }
        });
    }

    @Override
    public void sessionCreated(Session session, HttpServerExchange exchange2) {
        HttpSessionImpl httpSession = SecurityActions.forSession(session, this.servletContext, true);
        this.applicationListeners.sessionCreated(httpSession);
    }

    @Override
    public void sessionDestroyed(Session session, HttpServerExchange exchange2, SessionListener.SessionDestroyedReason reason) {
        if (reason == SessionListener.SessionDestroyedReason.TIMEOUT) {
            try {
                this.destroyedAction.call(exchange2, session);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.doDestroy(session);
        }
        ServletRequestContext current = SecurityActions.currentServletRequestContext();
        Session underlying = null;
        if (current != null && current.getSession() != null) {
            underlying = System.getSecurityManager() == null ? current.getSession().getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(current.getSession()));
        }
        if (current != null && underlying == session) {
            current.setSession(null);
        }
    }

    private void doDestroy(Session session) {
        HttpSessionImpl httpSession = SecurityActions.forSession(session, this.servletContext, false);
        this.applicationListeners.sessionDestroyed(httpSession);
        HashSet<String> names = new HashSet<String>(session.getAttributeNames());
        for (String attribute : names) {
            session.removeAttribute(attribute);
        }
    }

    @Override
    public void attributeAdded(Session session, String name, Object value) {
        if (name.startsWith(IO_UNDERTOW)) {
            return;
        }
        HttpSessionImpl httpSession = SecurityActions.forSession(session, this.servletContext, false);
        this.applicationListeners.httpSessionAttributeAdded(httpSession, name, value);
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent(httpSession, name, value));
        }
    }

    @Override
    public void attributeUpdated(Session session, String name, Object value, Object old) {
        if (name.startsWith(IO_UNDERTOW)) {
            return;
        }
        HttpSessionImpl httpSession = SecurityActions.forSession(session, this.servletContext, false);
        if (old != value) {
            if (old instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)old).valueUnbound(new HttpSessionBindingEvent(httpSession, name, old));
            }
            this.applicationListeners.httpSessionAttributeReplaced(httpSession, name, old);
        }
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent(httpSession, name, value));
        }
    }

    @Override
    public void attributeRemoved(Session session, String name, Object old) {
        if (name.startsWith(IO_UNDERTOW)) {
            return;
        }
        HttpSessionImpl httpSession = SecurityActions.forSession(session, this.servletContext, false);
        if (old != null) {
            this.applicationListeners.httpSessionAttributeRemoved(httpSession, name, old);
            if (old instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)old).valueUnbound(new HttpSessionBindingEvent(httpSession, name, old));
            }
        }
    }

    @Override
    public void sessionIdChanged(Session session, String oldSessionId) {
    }
}

