/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.ServletContextImpl;

public class SessionCookieConfigImpl
implements javax.servlet.SessionCookieConfig,
SessionConfig {
    private final ServletContextImpl servletContext;
    private final SessionCookieConfig delegate;
    private SessionConfig fallback;

    public SessionCookieConfigImpl(ServletContextImpl servletContext) {
        this.servletContext = servletContext;
        this.delegate = new SessionCookieConfig();
    }

    @Override
    public String rewriteUrl(String originalUrl, String sessionid) {
        if (this.fallback != null) {
            return this.fallback.rewriteUrl(originalUrl, sessionid);
        }
        return originalUrl;
    }

    @Override
    public void setSessionId(HttpServerExchange exchange2, String sessionId) {
        this.delegate.setSessionId(exchange2, sessionId);
    }

    @Override
    public void clearSession(HttpServerExchange exchange2, String sessionId) {
        this.delegate.clearSession(exchange2, sessionId);
    }

    @Override
    public String findSessionId(HttpServerExchange exchange2) {
        String existing = this.delegate.findSessionId(exchange2);
        if (existing != null) {
            return existing;
        }
        if (this.fallback != null) {
            return this.fallback.findSessionId(exchange2);
        }
        return null;
    }

    @Override
    public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange2) {
        String existing = this.delegate.findSessionId(exchange2);
        if (existing != null) {
            return SessionConfig.SessionCookieSource.COOKIE;
        }
        if (this.fallback != null) {
            String id = this.fallback.findSessionId(exchange2);
            return id != null ? this.fallback.sessionCookieSource(exchange2) : SessionConfig.SessionCookieSource.NONE;
        }
        return SessionConfig.SessionCookieSource.NONE;
    }

    @Override
    public String getName() {
        return this.delegate.getCookieName();
    }

    @Override
    public void setName(String name) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setCookieName(name);
    }

    @Override
    public String getDomain() {
        return this.delegate.getDomain();
    }

    @Override
    public void setDomain(String domain) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setDomain(domain);
    }

    @Override
    public String getPath() {
        return this.delegate.getPath();
    }

    @Override
    public void setPath(String path) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setPath(path);
    }

    @Override
    public String getComment() {
        return this.delegate.getComment();
    }

    @Override
    public void setComment(String comment) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setComment(comment);
    }

    @Override
    public boolean isHttpOnly() {
        return this.delegate.isHttpOnly();
    }

    @Override
    public void setHttpOnly(boolean httpOnly) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setHttpOnly(httpOnly);
    }

    @Override
    public boolean isSecure() {
        return this.delegate.isSecure();
    }

    @Override
    public void setSecure(boolean secure) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setSecure(secure);
    }

    @Override
    public int getMaxAge() {
        return this.delegate.getMaxAge();
    }

    @Override
    public void setMaxAge(int maxAge) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setMaxAge(maxAge);
    }

    public SessionConfig getFallback() {
        return this.fallback;
    }

    public void setFallback(SessionConfig fallback) {
        this.fallback = fallback;
    }
}

