/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.handshake;

import io.undertow.connector.ByteBufferPool;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.version08.Hybi08Handshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.util.Collections;
import org.xnio.StreamConnection;

public final class JsrHybi08Handshake
extends Hybi08Handshake {
    private final ConfiguredServerEndpoint config;

    public JsrHybi08Handshake(ConfiguredServerEndpoint config) {
        super(Collections.emptySet(), false);
        this.config = config;
    }

    @Override
    protected void upgradeChannel(WebSocketHttpExchange exchange2, byte[] data) {
        HandshakeUtil.prepareUpgrade(this.config.getEndpointConfiguration(), exchange2);
        super.upgradeChannel(exchange2, data);
    }

    @Override
    public WebSocketChannel createChannel(WebSocketHttpExchange exchange2, StreamConnection c, ByteBufferPool buffers) {
        WebSocketChannel channel = super.createChannel(exchange2, c, buffers);
        HandshakeUtil.setConfig(channel, this.config);
        return channel;
    }

    @Override
    public boolean matches(WebSocketHttpExchange exchange2) {
        return super.matches(exchange2) && HandshakeUtil.checkOrigin(this.config.getEndpointConfiguration(), exchange2);
    }

    @Override
    protected String supportedSubprotols(String[] requestedSubprotocolArray) {
        return HandshakeUtil.selectSubProtocol(this.config, requestedSubprotocolArray);
    }
}

