/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;

public class DefaultPropertiesPropertySource
extends MapPropertySource {
    public static final String NAME = "defaultProperties";

    public DefaultPropertiesPropertySource(Map<String, Object> source2) {
        super(NAME, source2);
    }

    public static boolean hasMatchingName(PropertySource<?> propertySource) {
        return propertySource != null && propertySource.getName().equals(NAME);
    }

    public static void ifNotEmpty(Map<String, Object> source2, Consumer<DefaultPropertiesPropertySource> action) {
        if (!CollectionUtils.isEmpty(source2) && action != null) {
            action.accept(new DefaultPropertiesPropertySource(source2));
        }
    }

    public static void addOrMerge(Map<String, Object> source2, MutablePropertySources sources) {
        if (!CollectionUtils.isEmpty(source2)) {
            HashMap<String, Object> resultingSource = new HashMap<String, Object>();
            DefaultPropertiesPropertySource propertySource = new DefaultPropertiesPropertySource(resultingSource);
            if (sources.contains(NAME)) {
                DefaultPropertiesPropertySource.mergeIfPossible(source2, sources, resultingSource);
                sources.replace(NAME, propertySource);
            } else {
                resultingSource.putAll(source2);
                sources.addLast(propertySource);
            }
        }
    }

    private static void mergeIfPossible(Map<String, Object> source2, MutablePropertySources sources, Map<String, Object> resultingSource) {
        PropertySource<?> existingSource = sources.get(NAME);
        if (existingSource != null) {
            Object underlyingSource = existingSource.getSource();
            if (underlyingSource instanceof Map) {
                resultingSource.putAll((Map)underlyingSource);
            }
            resultingSource.putAll(source2);
        }
    }

    public static void moveToEnd(ConfigurableEnvironment environment2) {
        DefaultPropertiesPropertySource.moveToEnd(environment2.getPropertySources());
    }

    public static void moveToEnd(MutablePropertySources propertySources) {
        PropertySource<?> propertySource = propertySources.remove(NAME);
        if (propertySource != null) {
            propertySources.addLast(propertySource);
        }
    }
}

