/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.convert;

import java.io.IOException;
import org.springframework.boot.origin.Origin;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

class InputStreamSourceToByteArrayConverter
implements Converter<InputStreamSource, byte[]> {
    InputStreamSourceToByteArrayConverter() {
    }

    @Override
    public byte[] convert(InputStreamSource source2) {
        try {
            return FileCopyUtils.copyToByteArray(source2.getInputStream());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to read from " + this.getName(source2), ex);
        }
    }

    private String getName(InputStreamSource source2) {
        Origin origin = Origin.from(source2);
        if (origin != null) {
            return origin.toString();
        }
        if (source2 instanceof Resource) {
            return ((Resource)source2).getDescription();
        }
        return "input stream source";
    }
}

