/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.convert;

import java.util.Collections;
import java.util.Set;
import org.springframework.boot.convert.DataSizeUnit;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.ObjectUtils;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

final class StringToDataSizeConverter
implements GenericConverter {
    StringToDataSizeConverter() {
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, DataSize.class));
    }

    @Override
    public Object convert(Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (ObjectUtils.isEmpty(source2)) {
            return null;
        }
        return this.convert(source2.toString(), this.getDataUnit(targetType));
    }

    private DataUnit getDataUnit(TypeDescriptor targetType) {
        DataSizeUnit annotation = targetType.getAnnotation(DataSizeUnit.class);
        return annotation != null ? annotation.value() : null;
    }

    private DataSize convert(String source2, DataUnit unit) {
        return DataSize.parse(source2, unit);
    }
}

