/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;

public class HostInfoEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private int order = -2147483639;

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment2, SpringApplication application) {
        InetUtils.HostInfo hostInfo = this.getFirstNonLoopbackHostInfo(environment2);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("spring.cloud.client.hostname", hostInfo.getHostname());
        map.put("spring.cloud.client.ip-address", hostInfo.getIpAddress());
        MapPropertySource propertySource = new MapPropertySource("springCloudClientHostInfo", (Map<String, Object>)map);
        environment2.getPropertySources().addLast(propertySource);
    }

    private InetUtils.HostInfo getFirstNonLoopbackHostInfo(ConfigurableEnvironment environment2) {
        InetUtilsProperties target = new InetUtilsProperties();
        ConfigurationPropertySources.attach(environment2);
        Binder.get(environment2).bind("spring.cloud.inetutils", Bindable.ofInstance(target));
        try (InetUtils utils = new InetUtils(target);){
            InetUtils.HostInfo hostInfo = utils.findFirstNonLoopbackHostInfo();
            return hostInfo;
        }
    }
}

