/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.reactive.OnNoRibbonDefaultCondition;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerExchangeFilterFunction;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WebClient.class})
@ConditionalOnBean(value={ReactiveLoadBalancer.Factory.class})
public class ReactorLoadBalancerClientAutoConfiguration {
    @Bean
    @ConditionalOnClass(name={"org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient"})
    @ConditionalOnProperty(value={"spring.cloud.loadbalancer.ribbon.enabled"}, matchIfMissing=true)
    public ReactorLoadBalancerClientRibbonWarnLogger reactorLoadBalancerClientRibbonWarnLogger() {
        return new ReactorLoadBalancerClientRibbonWarnLogger();
    }

    private static class ReactorLoadBalancerClientRibbonWarnLogger {
        private static final Log LOG = LogFactory.getLog(ReactorLoadBalancerClientRibbonWarnLogger.class);

        private ReactorLoadBalancerClientRibbonWarnLogger() {
        }

        @PostConstruct
        void logWarning() {
            if (LOG.isWarnEnabled()) {
                LOG.warn("You have RibbonLoadBalancerClient on your classpath. LoadBalancerExchangeFilterFunction that uses it under the hood will be used by default. Spring Cloud Ribbon is now in maintenance mode, so we suggest switching to " + ReactorLoadBalancerExchangeFilterFunction.class.getSimpleName() + " instead. In order to use it, set the value of `spring.cloud.loadbalancer.ribbon.enabled` to `false` or remove spring-cloud-starter-netflix-ribbon from your project.");
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={OnNoRibbonDefaultCondition.class})
    protected static class ReactorLoadBalancerExchangeFilterFunctionConfig {
        protected ReactorLoadBalancerExchangeFilterFunctionConfig() {
        }

        @ConditionalOnMissingBean
        @Bean
        public ReactorLoadBalancerExchangeFilterFunction loadBalancerExchangeFilterFunction(ReactiveLoadBalancer.Factory loadBalancerFactory) {
            return new ReactorLoadBalancerExchangeFilterFunction(loadBalancerFactory);
        }
    }
}

