/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

class HttpComponentsHeadersAdapter
implements MultiValueMap<String, String> {
    private final HttpResponse response;

    HttpComponentsHeadersAdapter(HttpResponse response) {
        this.response = response;
    }

    @Override
    public String getFirst(String key) {
        Header header = this.response.getFirstHeader(key);
        return header != null ? header.getValue() : null;
    }

    @Override
    public void add(String key, @Nullable String value) {
        this.response.addHeader(key, (Object)value);
    }

    @Override
    public void addAll(String key, List<? extends String> values2) {
        values2.forEach((? super T value) -> this.add(key, (String)value));
    }

    @Override
    public void addAll(MultiValueMap<String, String> values2) {
        values2.forEach(this::addAll);
    }

    @Override
    public void set(String key, @Nullable String value) {
        this.response.setHeader(key, (Object)value);
    }

    @Override
    public void setAll(Map<String, String> values2) {
        values2.forEach(this::set);
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> map = CollectionUtils.newLinkedHashMap(this.size());
        this.response.headerIterator().forEachRemaining(h2 -> map.putIfAbsent(h2.getName(), h2.getValue()));
        return map;
    }

    @Override
    public int size() {
        return this.response.getHeaders().length;
    }

    @Override
    public boolean isEmpty() {
        return this.response.getHeaders().length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.response.containsHeader((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return value instanceof String && Arrays.stream(this.response.getHeaders()).anyMatch(h2 -> h2.getValue().equals(value));
    }

    @Override
    @Nullable
    public List<String> get(Object key) {
        ArrayList<String> values2 = null;
        if (this.containsKey(key)) {
            Header[] headers = this.response.getHeaders((String)key);
            values2 = new ArrayList<String>(headers.length);
            for (Header header : headers) {
                values2.add(header.getValue());
            }
        }
        return values2;
    }

    @Override
    @Nullable
    public List<String> put(String key, List<String> values2) {
        Object oldValues = this.remove(key);
        values2.forEach((? super T value) -> this.add(key, (String)value));
        return oldValues;
    }

    @Override
    @Nullable
    public List<String> remove(Object key) {
        if (key instanceof String) {
            Object oldValues = this.get(key);
            this.response.removeHeaders((String)key);
            return oldValues;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map) {
        map.forEach(this::put);
    }

    @Override
    public void clear() {
        this.response.setHeaders(new Header[0]);
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> keys2 = new LinkedHashSet<String>(this.size());
        for (Header header : this.response.getHeaders()) {
            keys2.add(header.getName());
        }
        return keys2;
    }

    @Override
    public Collection<List<String>> values() {
        ArrayList<List<String>> values2 = new ArrayList<List<String>>(this.size());
        for (Header header : this.response.getHeaders()) {
            values2.add((List<String>)this.get(header.getName()));
        }
        return values2;
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return HttpComponentsHeadersAdapter.this.size();
            }
        };
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    private class HeaderEntry
    implements Map.Entry<String, List<String>> {
        private final String key;

        HeaderEntry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public List<String> getValue() {
            List<String> values2 = HttpComponentsHeadersAdapter.this.get(this.key);
            return values2 != null ? values2 : Collections.emptyList();
        }

        @Override
        public List<String> setValue(List<String> value) {
            Object previousValues = this.getValue();
            HttpComponentsHeadersAdapter.this.put(this.key, value);
            return previousValues;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private Iterator<Header> iterator;

        private EntryIterator() {
            this.iterator = HttpComponentsHeadersAdapter.this.response.headerIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return new HeaderEntry(this.iterator.next().getName());
        }
    }
}

