/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.custom;

import com.alibaba.cloud.sentinel.annotation.SentinelRestTemplate;
import com.alibaba.cloud.sentinel.custom.BlockClassRegistry;
import com.alibaba.cloud.sentinel.rest.SentinelClientHttpResponse;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestTemplate;

public class SentinelProtectInterceptor
implements ClientHttpRequestInterceptor {
    private final SentinelRestTemplate sentinelRestTemplate;
    private final RestTemplate restTemplate;

    public SentinelProtectInterceptor(SentinelRestTemplate sentinelRestTemplate, RestTemplate restTemplate) {
        this.sentinelRestTemplate = sentinelRestTemplate;
        this.restTemplate = restTemplate;
    }

    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body2, ClientHttpRequestExecution execution) throws IOException {
        Method urlCleanerMethod;
        URI uri = request.getURI();
        String hostResource = request.getMethod().toString() + ":" + uri.getScheme() + "://" + uri.getHost() + (uri.getPort() == -1 ? "" : ":" + uri.getPort());
        String hostWithPathResource = hostResource + uri.getPath();
        boolean entryWithPath = true;
        if (hostResource.equals(hostWithPathResource)) {
            entryWithPath = false;
        }
        if ((urlCleanerMethod = BlockClassRegistry.lookupUrlCleaner(this.sentinelRestTemplate.urlCleanerClass(), this.sentinelRestTemplate.urlCleaner())) != null) {
            hostWithPathResource = (String)this.methodInvoke(urlCleanerMethod, hostWithPathResource);
        }
        Entry hostEntry = null;
        Entry hostWithPathEntry = null;
        ClientHttpResponse response = null;
        try {
            hostEntry = SphU.entry(hostResource, EntryType.OUT);
            if (entryWithPath) {
                hostWithPathEntry = SphU.entry(hostWithPathResource, EntryType.OUT);
            }
            response = execution.execute(request, body2);
            if (this.restTemplate.getErrorHandler().hasError(response)) {
                Tracer.trace(new IllegalStateException("RestTemplate ErrorHandler has error"));
            }
            ClientHttpResponse clientHttpResponse = response;
            return clientHttpResponse;
        }
        catch (Throwable e) {
            if (BlockException.isBlockException(e)) {
                ClientHttpResponse clientHttpResponse = this.handleBlockException(request, body2, execution, (BlockException)e);
                return clientHttpResponse;
            }
            Tracer.traceEntry(e, hostEntry);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IOException(e);
        }
        finally {
            if (hostWithPathEntry != null) {
                hostWithPathEntry.exit();
            }
            if (hostEntry != null) {
                hostEntry.exit();
            }
        }
    }

    private ClientHttpResponse handleBlockException(HttpRequest request, byte[] body2, ClientHttpRequestExecution execution, BlockException ex) {
        Object[] args2 = new Object[]{request, body2, execution, ex};
        if (this.isDegradeFailure(ex)) {
            Method fallbackMethod = this.extractFallbackMethod(this.sentinelRestTemplate.fallback(), this.sentinelRestTemplate.fallbackClass());
            if (fallbackMethod != null) {
                return (ClientHttpResponse)this.methodInvoke(fallbackMethod, args2);
            }
            return new SentinelClientHttpResponse();
        }
        Method blockHandler = this.extractBlockHandlerMethod(this.sentinelRestTemplate.blockHandler(), this.sentinelRestTemplate.blockHandlerClass());
        if (blockHandler != null) {
            return (ClientHttpResponse)this.methodInvoke(blockHandler, args2);
        }
        return new SentinelClientHttpResponse();
    }

    private Object methodInvoke(Method method, Object ... args2) {
        try {
            return method.invoke(null, args2);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Method extractFallbackMethod(String fallback, Class<?> fallbackClass) {
        return BlockClassRegistry.lookupFallback(fallbackClass, fallback);
    }

    private Method extractBlockHandlerMethod(String block, Class<?> blockClass) {
        return BlockClassRegistry.lookupBlockHandler(blockClass, block);
    }

    private boolean isDegradeFailure(BlockException ex) {
        return ex instanceof DegradeException;
    }
}

