/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.feign;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class SentinelTargeterAspect {
    private static final ThreadLocal<Object> FEIGN_CLIENT_FACTORY_BEAN = new ThreadLocal();

    public static Object getFeignClientFactoryBean() {
        return FEIGN_CLIENT_FACTORY_BEAN.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* org.springframework.cloud.openfeign.Targeter.target(..))")
    public Object process(ProceedingJoinPoint pjp) throws Throwable {
        Object factory2 = pjp.getArgs()[0];
        try {
            FEIGN_CLIENT_FACTORY_BEAN.set(factory2);
            Object object = pjp.proceed();
            return object;
        }
        finally {
            FEIGN_CLIENT_FACTORY_BEAN.remove();
        }
    }
}

