/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.AbstractClientHttpResponse;

public class SentinelClientHttpResponse
extends AbstractClientHttpResponse {
    private String blockResponse = "RestTemplate request block by sentinel";

    public SentinelClientHttpResponse() {
    }

    public SentinelClientHttpResponse(String blockResponse) {
        this.blockResponse = blockResponse;
    }

    @Override
    public int getRawStatusCode() throws IOException {
        return HttpStatus.OK.value();
    }

    @Override
    public String getStatusText() throws IOException {
        return this.blockResponse;
    }

    @Override
    public void close() {
    }

    @Override
    public InputStream getBody() throws IOException {
        return new ByteArrayInputStream(this.blockResponse.getBytes());
    }

    @Override
    public HttpHeaders getHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Content-Type", Arrays.asList("application/json;charset=UTF-8"));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.putAll((Map<? extends String, ? extends List<String>>)headers);
        return httpHeaders;
    }
}

