/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.spring.webflux;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.adapter.reactor.ContextConfig;
import com.alibaba.csp.sentinel.adapter.reactor.EntryConfig;
import com.alibaba.csp.sentinel.adapter.reactor.SentinelReactorTransformer;
import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.WebFluxCallbackManager;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Optional;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class SentinelWebFluxFilter
implements WebFilter {
    private static final String EMPTY_ORIGIN = "";

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        String path = exchange2.getRequest().getPath().value();
        String finalPath = WebFluxCallbackManager.getUrlCleaner().apply(exchange2, path);
        if (StringUtil.isEmpty(finalPath)) {
            return chain.filter(exchange2);
        }
        return chain.filter(exchange2).transform(this.buildSentinelTransformer(exchange2, finalPath));
    }

    private SentinelReactorTransformer<Void> buildSentinelTransformer(ServerWebExchange exchange2, String finalPath) {
        String origin = Optional.ofNullable(WebFluxCallbackManager.getRequestOriginParser()).map(f -> (String)f.apply(exchange2)).orElse(EMPTY_ORIGIN);
        return new SentinelReactorTransformer<Void>(new EntryConfig(finalPath, 1, EntryType.IN, new ContextConfig(finalPath, origin)));
    }
}

