/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.spring.webflux.exception;

import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.WebFluxCallbackManager;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.function.Supplier;
import java.util.List;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

public class SentinelBlockExceptionHandler
implements WebExceptionHandler {
    private List<ViewResolver> viewResolvers;
    private List<HttpMessageWriter<?>> messageWriters;
    private final Supplier<ServerResponse.Context> contextSupplier = () -> new ServerResponse.Context(){

        public List<HttpMessageWriter<?>> messageWriters() {
            return SentinelBlockExceptionHandler.this.messageWriters;
        }

        public List<ViewResolver> viewResolvers() {
            return SentinelBlockExceptionHandler.this.viewResolvers;
        }
    };

    public SentinelBlockExceptionHandler(List<ViewResolver> viewResolvers, ServerCodecConfigurer serverCodecConfigurer) {
        this.viewResolvers = viewResolvers;
        this.messageWriters = serverCodecConfigurer.getWriters();
    }

    private Mono<Void> writeResponse(ServerResponse response, ServerWebExchange exchange2) {
        return response.writeTo(exchange2, this.contextSupplier.get());
    }

    @Override
    public Mono<Void> handle(ServerWebExchange exchange2, Throwable ex) {
        if (exchange2.getResponse().isCommitted()) {
            return Mono.error((Throwable)ex);
        }
        if (!BlockException.isBlockException(ex)) {
            return Mono.error((Throwable)ex);
        }
        return this.handleBlockedRequest(exchange2, ex).flatMap(response -> this.writeResponse((ServerResponse)response, exchange2));
    }

    private Mono<ServerResponse> handleBlockedRequest(ServerWebExchange exchange2, Throwable throwable) {
        return WebFluxCallbackManager.getBlockHandler().handleRequest(exchange2, throwable);
    }
}

