/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.codec;

import com.alibaba.csp.sentinel.cluster.client.codec.registry.RequestDataWriterRegistry;
import com.alibaba.csp.sentinel.cluster.codec.EntityWriter;
import com.alibaba.csp.sentinel.cluster.codec.request.RequestEntityWriter;
import com.alibaba.csp.sentinel.cluster.request.ClusterRequest;
import com.alibaba.csp.sentinel.cluster.request.Request;
import com.alibaba.csp.sentinel.log.RecordLog;
import io.netty.buffer.ByteBuf;

public class DefaultRequestEntityWriter
implements RequestEntityWriter<ClusterRequest, ByteBuf> {
    @Override
    public void writeTo(ClusterRequest request, ByteBuf target) {
        int type = request.getType();
        EntityWriter<Object, ByteBuf> requestDataWriter = RequestDataWriterRegistry.getWriter(type);
        if (requestDataWriter == null) {
            RecordLog.warn("[DefaultRequestEntityWriter] Cannot find matching request writer for type <{}>, dropping the request", type);
            return;
        }
        this.writeHead(request, target);
        requestDataWriter.writeTo(request.getData(), target);
    }

    private void writeHead(Request request, ByteBuf out) {
        out.writeInt(request.getId());
        out.writeByte(request.getType());
    }
}

