/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.codec;

import com.alibaba.csp.sentinel.cluster.client.codec.registry.ResponseDataDecodeRegistry;
import com.alibaba.csp.sentinel.cluster.codec.EntityDecoder;
import com.alibaba.csp.sentinel.cluster.codec.response.ResponseEntityDecoder;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.log.RecordLog;
import io.netty.buffer.ByteBuf;

public class DefaultResponseEntityDecoder
implements ResponseEntityDecoder<ByteBuf, ClusterResponse> {
    @Override
    public ClusterResponse decode(ByteBuf source2) {
        if (source2.readableBytes() >= 6) {
            int xid = source2.readInt();
            byte type = source2.readByte();
            byte status = source2.readByte();
            EntityDecoder<ByteBuf, Object> decoder = ResponseDataDecodeRegistry.getDecoder(type);
            if (decoder == null) {
                RecordLog.warn("Unknown type of response data decoder: {}", type);
                return null;
            }
            Object data = source2.readableBytes() == 0 ? null : decoder.decode(source2);
            return new ClusterResponse<Object>(xid, type, status, data);
        }
        return null;
    }
}

