/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow;

import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.flow.statistic.ClusterMetricStatistics;
import com.alibaba.csp.sentinel.cluster.flow.statistic.data.ClusterFlowEvent;
import com.alibaba.csp.sentinel.cluster.flow.statistic.limit.GlobalRequestLimiter;
import com.alibaba.csp.sentinel.cluster.flow.statistic.metric.ClusterMetric;
import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.cluster.server.log.ClusterServerStatLogUtil;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;

final class ClusterFlowChecker {
    private static double calcGlobalThreshold(FlowRule rule) {
        double count = rule.getCount();
        switch (rule.getClusterConfig().getThresholdType()) {
            case 1: {
                return count;
            }
        }
        int connectedCount = ClusterFlowRuleManager.getConnectedCount(rule.getClusterConfig().getFlowId());
        return count * (double)connectedCount;
    }

    static boolean allowProceed(long flowId) {
        String namespace = ClusterFlowRuleManager.getNamespace(flowId);
        return GlobalRequestLimiter.tryPass(namespace);
    }

    static TokenResult acquireClusterToken(FlowRule rule, int acquireCount, boolean prioritized) {
        int waitInMs;
        double occupyAvg;
        Long id = rule.getClusterConfig().getFlowId();
        if (!ClusterFlowChecker.allowProceed(id)) {
            return new TokenResult(-2);
        }
        ClusterMetric metric = ClusterMetricStatistics.getMetric(id);
        if (metric == null) {
            return new TokenResult(-1);
        }
        double latestQps = metric.getAvg(ClusterFlowEvent.PASS);
        double globalThreshold = ClusterFlowChecker.calcGlobalThreshold(rule) * ClusterServerConfigManager.getExceedCount();
        double nextRemaining = globalThreshold - latestQps - (double)acquireCount;
        if (nextRemaining >= 0.0) {
            metric.add(ClusterFlowEvent.PASS, acquireCount);
            metric.add(ClusterFlowEvent.PASS_REQUEST, 1L);
            if (prioritized) {
                metric.add(ClusterFlowEvent.OCCUPIED_PASS, acquireCount);
            }
            return new TokenResult(0).setRemaining((int)nextRemaining).setWaitInMs(0);
        }
        if (prioritized && (occupyAvg = metric.getAvg(ClusterFlowEvent.WAITING)) <= ClusterServerConfigManager.getMaxOccupyRatio() * globalThreshold && (waitInMs = metric.tryOccupyNext(ClusterFlowEvent.PASS, acquireCount, globalThreshold)) > 0) {
            ClusterServerStatLogUtil.log("flow|waiting|" + id);
            return new TokenResult(2).setRemaining(0).setWaitInMs(waitInMs);
        }
        metric.add(ClusterFlowEvent.BLOCK, acquireCount);
        metric.add(ClusterFlowEvent.BLOCK_REQUEST, 1L);
        ClusterServerStatLogUtil.log("flow|block|" + id, acquireCount);
        ClusterServerStatLogUtil.log("flow|block_request|" + id, 1);
        if (prioritized) {
            metric.add(ClusterFlowEvent.OCCUPIED_BLOCK, acquireCount);
            ClusterServerStatLogUtil.log("flow|occupied_block|" + id, 1);
        }
        return ClusterFlowChecker.blockedResult();
    }

    private static TokenResult blockedResult() {
        return new TokenResult(1).setRemaining(0).setWaitInMs(0);
    }

    private ClusterFlowChecker() {
    }
}

