/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.rule;

import com.alibaba.csp.sentinel.cluster.flow.rule.NamespaceFlowProperty;
import com.alibaba.csp.sentinel.cluster.flow.statistic.ClusterMetricStatistics;
import com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent.CurrentConcurrencyManager;
import com.alibaba.csp.sentinel.cluster.flow.statistic.metric.ClusterMetric;
import com.alibaba.csp.sentinel.cluster.server.connection.ConnectionManager;
import com.alibaba.csp.sentinel.cluster.server.util.ClusterRuleUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.flow.ClusterFlowConfig;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleUtil;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.function.Function;
import com.alibaba.csp.sentinel.util.function.Predicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ClusterFlowRuleManager {
    public static final Function<String, SentinelProperty<List<FlowRule>>> DEFAULT_PROPERTY_SUPPLIER = new Function<String, SentinelProperty<List<FlowRule>>>(){

        @Override
        public SentinelProperty<List<FlowRule>> apply(String namespace) {
            return new DynamicSentinelProperty<List<FlowRule>>();
        }
    };
    private static final Map<Long, FlowRule> FLOW_RULES = new ConcurrentHashMap<Long, FlowRule>();
    private static final Map<String, Set<Long>> NAMESPACE_FLOW_ID_MAP = new ConcurrentHashMap<String, Set<Long>>();
    private static final Map<Long, String> FLOW_NAMESPACE_MAP = new ConcurrentHashMap<Long, String>();
    private static final Map<String, NamespaceFlowProperty<FlowRule>> PROPERTY_MAP = new ConcurrentHashMap<String, NamespaceFlowProperty<FlowRule>>();
    private static volatile Function<String, SentinelProperty<List<FlowRule>>> propertySupplier = DEFAULT_PROPERTY_SUPPLIER;
    private static final Object UPDATE_LOCK = new Object();

    private static void initDefaultProperty() {
        DynamicSentinelProperty<List<FlowRule>> defaultProperty = new DynamicSentinelProperty<List<FlowRule>>();
        String defaultNamespace = "default";
        ClusterFlowRuleManager.registerPropertyInternal(defaultNamespace, defaultProperty);
    }

    public static void setPropertySupplier(Function<String, SentinelProperty<List<FlowRule>>> propertySupplier) {
        AssertUtil.notNull(propertySupplier, "flow rule property supplier cannot be null");
        ClusterFlowRuleManager.propertySupplier = propertySupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(String namespace) {
        AssertUtil.notEmpty(namespace, "namespace cannot be empty");
        if (propertySupplier == null) {
            RecordLog.warn("[ClusterFlowRuleManager] Cluster flow property supplier is absent, cannot register property", new Object[0]);
            return;
        }
        SentinelProperty<List<FlowRule>> property = propertySupplier.apply(namespace);
        if (property == null) {
            RecordLog.warn("[ClusterFlowRuleManager] Wrong created property from cluster flow property supplier, ignoring", new Object[0]);
            return;
        }
        Object object = UPDATE_LOCK;
        synchronized (object) {
            RecordLog.info("[ClusterFlowRuleManager] Registering new property to cluster flow rule manager for namespace <{}>", namespace);
            ClusterFlowRuleManager.registerPropertyInternal(namespace, property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPropertyIfAbsent(String namespace) {
        AssertUtil.notEmpty(namespace, "namespace cannot be empty");
        if (!PROPERTY_MAP.containsKey(namespace)) {
            Object object = UPDATE_LOCK;
            synchronized (object) {
                if (!PROPERTY_MAP.containsKey(namespace)) {
                    ClusterFlowRuleManager.register2Property(namespace);
                }
            }
        }
    }

    private static void registerPropertyInternal(String namespace, SentinelProperty<List<FlowRule>> property) {
        NamespaceFlowProperty<FlowRule> oldProperty = PROPERTY_MAP.get(namespace);
        if (oldProperty != null) {
            oldProperty.getProperty().removeListener(oldProperty.getListener());
        }
        FlowRulePropertyListener listener = new FlowRulePropertyListener(namespace);
        property.addListener(listener);
        PROPERTY_MAP.put(namespace, new NamespaceFlowProperty<FlowRule>(namespace, property, listener));
        Set<Long> flowIdSet = NAMESPACE_FLOW_ID_MAP.get(namespace);
        if (flowIdSet == null) {
            ClusterFlowRuleManager.resetNamespaceFlowIdMapFor(namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProperty(String namespace) {
        AssertUtil.notEmpty(namespace, "namespace cannot be empty");
        Object object = UPDATE_LOCK;
        synchronized (object) {
            NamespaceFlowProperty<FlowRule> property = PROPERTY_MAP.get(namespace);
            if (property != null) {
                property.getProperty().removeListener(property.getListener());
                PROPERTY_MAP.remove(namespace);
            }
            RecordLog.info("[ClusterFlowRuleManager] Removing property from cluster flow rule manager for namespace <{}>", namespace);
        }
    }

    private static void removePropertyListeners() {
        for (NamespaceFlowProperty<FlowRule> property : PROPERTY_MAP.values()) {
            property.getProperty().removeListener(property.getListener());
        }
    }

    private static void restorePropertyListeners() {
        for (NamespaceFlowProperty<FlowRule> p : PROPERTY_MAP.values()) {
            p.getProperty().removeListener(p.getListener());
            p.getProperty().addListener(p.getListener());
        }
    }

    public static FlowRule getFlowRuleById(Long id) {
        if (!ClusterRuleUtil.validId(id)) {
            return null;
        }
        return FLOW_RULES.get(id);
    }

    public static Set<Long> getFlowIdSet(String namespace) {
        if (StringUtil.isEmpty(namespace)) {
            return new HashSet<Long>();
        }
        Set<Long> set = NAMESPACE_FLOW_ID_MAP.get(namespace);
        if (set == null) {
            return new HashSet<Long>();
        }
        return new HashSet<Long>(set);
    }

    public static List<FlowRule> getAllFlowRules() {
        return new ArrayList<FlowRule>(FLOW_RULES.values());
    }

    public static List<FlowRule> getFlowRules(String namespace) {
        if (StringUtil.isEmpty(namespace)) {
            return new ArrayList<FlowRule>();
        }
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        Set<Long> flowIdSet = NAMESPACE_FLOW_ID_MAP.get(namespace);
        if (flowIdSet == null || flowIdSet.isEmpty()) {
            return rules;
        }
        for (Long flowId : flowIdSet) {
            FlowRule rule = FLOW_RULES.get(flowId);
            if (rule == null) continue;
            rules.add(rule);
        }
        return rules;
    }

    public static void loadRules(String namespace, List<FlowRule> rules) {
        AssertUtil.notEmpty(namespace, "namespace cannot be empty");
        NamespaceFlowProperty<FlowRule> property = PROPERTY_MAP.get(namespace);
        if (property != null) {
            property.getProperty().updateValue(rules);
        }
    }

    private static void resetNamespaceFlowIdMapFor(String namespace) {
        NAMESPACE_FLOW_ID_MAP.put(namespace, new HashSet());
    }

    private static void clearAndResetRulesFor(String namespace) {
        Set<Long> flowIdSet = NAMESPACE_FLOW_ID_MAP.get(namespace);
        if (flowIdSet != null && !flowIdSet.isEmpty()) {
            for (Long flowId : flowIdSet) {
                FLOW_RULES.remove(flowId);
                FLOW_NAMESPACE_MAP.remove(flowId);
                if (!CurrentConcurrencyManager.containsFlowId(flowId)) continue;
                CurrentConcurrencyManager.remove(flowId);
            }
            flowIdSet.clear();
        } else {
            ClusterFlowRuleManager.resetNamespaceFlowIdMapFor(namespace);
        }
    }

    private static void clearAndResetRulesConditional(String namespace, Predicate<Long> predicate) {
        Set<Long> oldIdSet = NAMESPACE_FLOW_ID_MAP.get(namespace);
        if (oldIdSet != null && !oldIdSet.isEmpty()) {
            for (Long flowId : oldIdSet) {
                if (!predicate.test(flowId)) continue;
                FLOW_RULES.remove(flowId);
                FLOW_NAMESPACE_MAP.remove(flowId);
                ClusterMetricStatistics.removeMetric(flowId);
                if (!CurrentConcurrencyManager.containsFlowId(flowId)) continue;
                CurrentConcurrencyManager.remove(flowId);
            }
            oldIdSet.clear();
        }
    }

    public static int getConnectedCount(long flowId) {
        if (flowId <= 0L) {
            return 0;
        }
        String namespace = FLOW_NAMESPACE_MAP.get(flowId);
        if (namespace == null) {
            return 0;
        }
        return ConnectionManager.getConnectedCount(namespace);
    }

    public static String getNamespace(long flowId) {
        return FLOW_NAMESPACE_MAP.get(flowId);
    }

    private static void applyClusterFlowRule(List<FlowRule> list, String namespace) {
        if (list == null || list.isEmpty()) {
            ClusterFlowRuleManager.clearAndResetRulesFor(namespace);
            return;
        }
        final ConcurrentHashMap<Long, FlowRule> ruleMap = new ConcurrentHashMap<Long, FlowRule>();
        HashSet<Long> flowIdSet = new HashSet<Long>();
        for (FlowRule rule : list) {
            ClusterFlowConfig clusterConfig;
            Long flowId;
            if (!rule.isClusterMode()) continue;
            if (!FlowRuleUtil.isValidRule(rule)) {
                RecordLog.warn("[ClusterFlowRuleManager] Ignoring invalid flow rule when loading new flow rules: " + rule, new Object[0]);
                continue;
            }
            if (StringUtil.isBlank(rule.getLimitApp())) {
                rule.setLimitApp("default");
            }
            if ((flowId = (clusterConfig = rule.getClusterConfig()).getFlowId()) == null) continue;
            ruleMap.put(flowId, rule);
            FLOW_NAMESPACE_MAP.put(flowId, namespace);
            flowIdSet.add(flowId);
            if (!CurrentConcurrencyManager.containsFlowId(flowId)) {
                CurrentConcurrencyManager.put(flowId, 0);
            }
            ClusterMetricStatistics.putMetricIfAbsent(flowId, new ClusterMetric(clusterConfig.getSampleCount(), clusterConfig.getWindowIntervalMs()));
        }
        ClusterFlowRuleManager.clearAndResetRulesConditional(namespace, new Predicate<Long>(){

            @Override
            public boolean test(Long flowId) {
                return !ruleMap.containsKey(flowId);
            }
        });
        FLOW_RULES.putAll(ruleMap);
        NAMESPACE_FLOW_ID_MAP.put(namespace, flowIdSet);
    }

    private ClusterFlowRuleManager() {
    }

    static {
        ClusterFlowRuleManager.initDefaultProperty();
    }

    private static final class FlowRulePropertyListener
    implements PropertyListener<List<FlowRule>> {
        private final String namespace;

        public FlowRulePropertyListener(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public synchronized void configUpdate(List<FlowRule> conf) {
            ClusterFlowRuleManager.applyClusterFlowRule(conf, this.namespace);
            RecordLog.info("[ClusterFlowRuleManager] Cluster flow rules received for namespace <{}>: {}", this.namespace, FLOW_RULES);
        }

        @Override
        public synchronized void configLoad(List<FlowRule> conf) {
            ClusterFlowRuleManager.applyClusterFlowRule(conf, this.namespace);
            RecordLog.info("[ClusterFlowRuleManager] Cluster flow rules loaded for namespace <{}>: {}", this.namespace, FLOW_RULES);
        }
    }
}

