/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent;

import com.alibaba.csp.sentinel.cluster.flow.ConcurrentClusterFlowChecker;
import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent.CurrentConcurrencyManager;
import com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent.TokenCacheNodeManager;
import com.alibaba.csp.sentinel.cluster.server.log.ClusterServerStatLogUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import java.util.Set;

public class ClusterConcurrentCheckerLogListener
implements Runnable {
    @Override
    public void run() {
        try {
            this.collectInformation();
        }
        catch (Exception e) {
            RecordLog.warn("[ClusterConcurrentCheckerLogListener] Failed to record concurrent flow control  regularly", e);
        }
    }

    private void collectInformation() {
        Set<Long> keySet = CurrentConcurrencyManager.getConcurrencyMapKeySet();
        for (long flowId : keySet) {
            FlowRule rule = ClusterFlowRuleManager.getFlowRuleById(flowId);
            if (rule == null || CurrentConcurrencyManager.get(flowId).get() == 0) continue;
            double concurrencyLevel = ConcurrentClusterFlowChecker.calcGlobalThreshold(rule);
            String resource = rule.getResource();
            ClusterServerStatLogUtil.log(String.format("concurrent|resource:%s|flowId:%dl|concurrencyLevel:%fl|currentConcurrency", resource, flowId, concurrencyLevel), CurrentConcurrencyManager.get(flowId).get());
        }
        if (TokenCacheNodeManager.getSize() != 0) {
            ClusterServerStatLogUtil.log("flow|totalTokenSize", TokenCacheNodeManager.getSize());
        }
    }
}

