/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent;

import com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent.ClusterConcurrentCheckerLogListener;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class CurrentConcurrencyManager {
    private static final ConcurrentHashMap<Long, AtomicInteger> NOW_CALLS_MAP = new ConcurrentHashMap();
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, new NamedThreadFactory("sentinel-cluster-concurrency-record-task", true));

    public static void addConcurrency(Long flowId, Integer acquireCount) {
        AtomicInteger nowCalls = NOW_CALLS_MAP.get(flowId);
        if (nowCalls == null) {
            return;
        }
        nowCalls.getAndAdd(acquireCount);
    }

    public static AtomicInteger get(Long flowId) {
        return NOW_CALLS_MAP.get(flowId);
    }

    public static void remove(Long flowId) {
        NOW_CALLS_MAP.remove(flowId);
    }

    public static void put(Long flowId, Integer nowCalls) {
        NOW_CALLS_MAP.put(flowId, new AtomicInteger(nowCalls));
    }

    public static boolean containsFlowId(Long flowId) {
        return NOW_CALLS_MAP.containsKey(flowId);
    }

    public static Set<Long> getConcurrencyMapKeySet() {
        return NOW_CALLS_MAP.keySet();
    }

    static {
        ClusterConcurrentCheckerLogListener logTask = new ClusterConcurrentCheckerLogListener();
        SCHEDULER.scheduleAtFixedRate(logTask, 0L, 1L, TimeUnit.SECONDS);
    }
}

