/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.metric;

import com.alibaba.csp.sentinel.slots.statistic.base.LeapArray;
import com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import com.alibaba.csp.sentinel.slots.statistic.cache.CacheMap;
import com.alibaba.csp.sentinel.slots.statistic.cache.ConcurrentLinkedHashMapWrapper;
import com.alibaba.csp.sentinel.util.AssertUtil;

public class ClusterParameterLeapArray<C>
extends LeapArray<CacheMap<Object, C>> {
    private final int maxCapacity;

    public ClusterParameterLeapArray(int sampleCount, int intervalInMs, int maxCapacity) {
        super(sampleCount, intervalInMs);
        AssertUtil.isTrue(maxCapacity > 0, "maxCapacity of LRU map should be positive");
        this.maxCapacity = maxCapacity;
    }

    @Override
    public CacheMap<Object, C> newEmptyBucket(long timeMillis) {
        return new ConcurrentLinkedHashMapWrapper(this.maxCapacity);
    }

    @Override
    protected WindowWrap<CacheMap<Object, C>> resetWindowTo(WindowWrap<CacheMap<Object, C>> w, long startTime) {
        w.resetTo(startTime);
        w.value().clear();
        return w;
    }
}

