/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server;

import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.registry.ConfigSupplierRegistry;
import com.alibaba.csp.sentinel.cluster.server.ClusterTokenServer;
import com.alibaba.csp.sentinel.cluster.server.NettyTransportServer;
import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.cluster.server.config.ServerTransportConfig;
import com.alibaba.csp.sentinel.cluster.server.config.ServerTransportConfigObserver;
import com.alibaba.csp.sentinel.cluster.server.connection.ConnectionManager;
import com.alibaba.csp.sentinel.init.InitExecutor;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.HostNameUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class SentinelDefaultTokenServer
implements ClusterTokenServer {
    private final boolean embedded;
    private ClusterTokenServer server;
    private int port;
    private final AtomicBoolean shouldStart = new AtomicBoolean(false);

    public SentinelDefaultTokenServer() {
        this(false);
    }

    public SentinelDefaultTokenServer(boolean embedded) {
        this.embedded = embedded;
        ClusterServerConfigManager.addTransportConfigChangeObserver(new ServerTransportConfigObserver(){

            @Override
            public void onTransportConfigChange(ServerTransportConfig config) {
                SentinelDefaultTokenServer.this.changeServerConfig(config);
            }
        });
        this.initNewServer();
    }

    private void initNewServer() {
        if (this.server != null) {
            return;
        }
        int port = ClusterServerConfigManager.getPort();
        if (port > 0) {
            this.server = new NettyTransportServer(port);
            this.port = port;
        }
    }

    private synchronized void changeServerConfig(ServerTransportConfig config) {
        if (config == null || config.getPort() <= 0) {
            return;
        }
        int newPort = config.getPort();
        if (newPort == this.port) {
            return;
        }
        try {
            if (this.server != null) {
                this.stopServer();
            }
            this.server = new NettyTransportServer(newPort);
            this.port = newPort;
            this.startServerIfScheduled();
        }
        catch (Exception ex) {
            RecordLog.warn("[SentinelDefaultTokenServer] Failed to apply modification to token server", ex);
        }
    }

    private void startServerIfScheduled() throws Exception {
        if (this.shouldStart.get() && this.server != null) {
            this.server.start();
            ClusterStateManager.markToServer();
            if (this.embedded) {
                RecordLog.info("[SentinelDefaultTokenServer] Running in embedded mode", new Object[0]);
                this.handleEmbeddedStart();
            }
        }
    }

    private void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
            if (this.embedded) {
                this.handleEmbeddedStop();
            }
        }
    }

    private void handleEmbeddedStop() {
        String namespace = ConfigSupplierRegistry.getNamespaceSupplier().get();
        if (StringUtil.isNotEmpty(namespace)) {
            ConnectionManager.removeConnection(namespace, HostNameUtil.getIp());
        }
    }

    private void handleEmbeddedStart() {
        String namespace = ConfigSupplierRegistry.getNamespaceSupplier().get();
        if (StringUtil.isNotEmpty(namespace)) {
            ClusterServerConfigManager.setEmbedded(true);
            if (!ClusterServerConfigManager.getNamespaceSet().contains(namespace)) {
                HashSet<String> namespaceSet = new HashSet<String>(ClusterServerConfigManager.getNamespaceSet());
                namespaceSet.add(namespace);
                ClusterServerConfigManager.loadServerNamespaceSet(namespaceSet);
            }
            ConnectionManager.addConnection(namespace, HostNameUtil.getIp());
        }
    }

    @Override
    public void start() throws Exception {
        if (this.shouldStart.compareAndSet(false, true)) {
            this.startServerIfScheduled();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.shouldStart.compareAndSet(true, false)) {
            this.stopServer();
        }
    }

    static {
        InitExecutor.doInit();
    }
}

