/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.codec.data;

import com.alibaba.csp.sentinel.cluster.codec.EntityDecoder;
import com.alibaba.csp.sentinel.cluster.request.data.ParamFlowRequestData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class ParamFlowRequestDataDecoder
implements EntityDecoder<ByteBuf, ParamFlowRequestData> {
    @Override
    public ParamFlowRequestData decode(ByteBuf source2) {
        if (source2.readableBytes() >= 16) {
            ParamFlowRequestData requestData = new ParamFlowRequestData().setFlowId(source2.readLong()).setCount(source2.readInt());
            int amount = source2.readInt();
            if (amount > 0) {
                ArrayList<Object> params = new ArrayList<Object>(amount);
                for (int i2 = 0; i2 < amount; ++i2) {
                    this.decodeParam(source2, params);
                }
                requestData.setParams(params);
                return requestData;
            }
        }
        return null;
    }

    private boolean decodeParam(ByteBuf source2, List<Object> params) {
        byte paramType = source2.readByte();
        switch (paramType) {
            case 0: {
                params.add(source2.readInt());
                return true;
            }
            case 7: {
                int length = source2.readInt();
                byte[] bytes = new byte[length];
                source2.readBytes(bytes);
                params.add(new String(bytes));
                return true;
            }
            case 6: {
                params.add(source2.readBoolean());
                return true;
            }
            case 3: {
                params.add(source2.readDouble());
                return true;
            }
            case 1: {
                params.add(source2.readLong());
                return true;
            }
            case 4: {
                params.add(Float.valueOf(source2.readFloat()));
                return true;
            }
            case 2: {
                params.add(source2.readByte());
                return true;
            }
            case 5: {
                params.add(source2.readShort());
                return true;
            }
        }
        return false;
    }
}

