/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.command.handler;

import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterFlowRuleManager;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import java.net.URLDecoder;
import java.util.List;

@CommandMapping(name="cluster/server/modifyFlowRules", desc="modify cluster flow rules")
public class ModifyClusterFlowRulesCommandHandler
implements CommandHandler<String> {
    private static final String SUCCESS = "success";

    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        String namespace = request.getParam("namespace");
        if (StringUtil.isEmpty(namespace)) {
            return CommandResponse.ofFailure(new IllegalArgumentException("empty namespace"));
        }
        String data = request.getParam("data");
        if (StringUtil.isBlank(data)) {
            return CommandResponse.ofFailure(new IllegalArgumentException("empty data"));
        }
        try {
            data = URLDecoder.decode(data, "UTF-8");
            RecordLog.info("[ModifyClusterFlowRulesCommandHandler] Receiving cluster flow rules for namespace <{}>: {}", namespace, data);
            List<FlowRule> flowRules = JSONArray.parseArray(data, FlowRule.class);
            ClusterFlowRuleManager.loadRules(namespace, flowRules);
            return CommandResponse.ofSuccess(SUCCESS);
        }
        catch (Exception e) {
            RecordLog.warn("[ModifyClusterFlowRulesCommandHandler] Decode cluster flow rules error", e);
            return CommandResponse.ofFailure(e, "decode cluster flow rules error");
        }
    }
}

