/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.command.handler;

import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.net.URLDecoder;
import java.util.Set;

@CommandMapping(name="cluster/server/modifyNamespaceSet", desc="modify server namespace set")
public class ModifyServerNamespaceSetHandler
implements CommandHandler<String> {
    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        String data = request.getParam("data");
        if (StringUtil.isBlank(data)) {
            return CommandResponse.ofFailure(new IllegalArgumentException("empty data"));
        }
        try {
            data = URLDecoder.decode(data, "utf-8");
            RecordLog.info("[ModifyServerNamespaceSetHandler] Receiving cluster server namespace set: {}", data);
            Set<String> set = JSON.parseObject(data, new TypeReference<Set<String>>(){}, new Feature[0]);
            ClusterServerConfigManager.loadServerNamespaceSet(set);
            return CommandResponse.ofSuccess("success");
        }
        catch (Exception e) {
            RecordLog.warn("[ModifyServerNamespaceSetHandler] Decode cluster server namespace set error", e);
            return CommandResponse.ofFailure(e, "decode client cluster config error");
        }
    }
}

