/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.handler;

import com.alibaba.csp.sentinel.cluster.request.ClusterRequest;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.cluster.server.connection.ConnectionManager;
import com.alibaba.csp.sentinel.cluster.server.connection.ConnectionPool;
import com.alibaba.csp.sentinel.cluster.server.processor.RequestProcessor;
import com.alibaba.csp.sentinel.cluster.server.processor.RequestProcessorProvider;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;

public class TokenServerHandler
extends ChannelInboundHandlerAdapter {
    private final ConnectionPool globalConnectionPool;

    public TokenServerHandler(ConnectionPool globalConnectionPool) {
        this.globalConnectionPool = globalConnectionPool;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.globalConnectionPool.createConnection(ctx.channel());
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String remoteAddress = this.getRemoteAddress(ctx);
        this.globalConnectionPool.remove(ctx.channel());
        ConnectionManager.removeConnection(remoteAddress);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.globalConnectionPool.refreshLastReadTime(ctx.channel());
        if (msg instanceof ClusterRequest) {
            ClusterRequest request = (ClusterRequest)msg;
            if (request.getType() == 0) {
                this.handlePingRequest(ctx, request);
                return;
            }
            RequestProcessor processor = RequestProcessorProvider.getProcessor(request.getType());
            if (processor == null) {
                RecordLog.warn("[TokenServerHandler] No processor for request type: " + request.getType(), new Object[0]);
                this.writeBadResponse(ctx, request);
            } else {
                ClusterResponse response = processor.processRequest(request);
                this.writeResponse(ctx, response);
            }
        }
    }

    private void writeBadResponse(ChannelHandlerContext ctx, ClusterRequest request) {
        ClusterResponse<Object> response = new ClusterResponse<Object>(request.getId(), request.getType(), -1, null);
        this.writeResponse(ctx, response);
    }

    private void writeResponse(ChannelHandlerContext ctx, ClusterResponse response) {
        ctx.writeAndFlush(response);
    }

    private void handlePingRequest(ChannelHandlerContext ctx, ClusterRequest request) {
        if (request.getData() == null || StringUtil.isBlank((String)request.getData())) {
            this.writeBadResponse(ctx, request);
            return;
        }
        String namespace = (String)request.getData();
        String clientAddress = this.getRemoteAddress(ctx);
        int curCount = ConnectionManager.addConnection(namespace, clientAddress).getConnectedCount();
        int status = 0;
        ClusterResponse<Integer> response = new ClusterResponse<Integer>(request.getId(), request.getType(), status, curCount);
        this.writeResponse(ctx, response);
    }

    private String getRemoteAddress(ChannelHandlerContext ctx) {
        if (ctx.channel().remoteAddress() == null) {
            return null;
        }
        InetSocketAddress inetAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        return inetAddress.getAddress().getHostAddress() + ":" + inetAddress.getPort();
    }
}

