/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.param;

import com.alibaba.csp.sentinel.slots.block.AbstractRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowClusterConfig;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ParamFlowRule
extends AbstractRule {
    private int grade = 1;
    private Integer paramIdx;
    private double count;
    private int controlBehavior = 0;
    private int maxQueueingTimeMs = 0;
    private int burstCount = 0;
    private long durationInSec = 1L;
    private List<ParamFlowItem> paramFlowItemList = new ArrayList<ParamFlowItem>();
    private Map<Object, Integer> hotItems = new HashMap<Object, Integer>();
    private boolean clusterMode = false;
    private ParamFlowClusterConfig clusterConfig;

    public ParamFlowRule() {
    }

    public ParamFlowRule(String resourceName) {
        this.setResource(resourceName);
    }

    public int getControlBehavior() {
        return this.controlBehavior;
    }

    public ParamFlowRule setControlBehavior(int controlBehavior) {
        this.controlBehavior = controlBehavior;
        return this;
    }

    public int getMaxQueueingTimeMs() {
        return this.maxQueueingTimeMs;
    }

    public ParamFlowRule setMaxQueueingTimeMs(int maxQueueingTimeMs) {
        this.maxQueueingTimeMs = maxQueueingTimeMs;
        return this;
    }

    public int getBurstCount() {
        return this.burstCount;
    }

    public ParamFlowRule setBurstCount(int burstCount) {
        this.burstCount = burstCount;
        return this;
    }

    public long getDurationInSec() {
        return this.durationInSec;
    }

    public ParamFlowRule setDurationInSec(long durationInSec) {
        this.durationInSec = durationInSec;
        return this;
    }

    public int getGrade() {
        return this.grade;
    }

    public ParamFlowRule setGrade(int grade) {
        this.grade = grade;
        return this;
    }

    public Integer getParamIdx() {
        return this.paramIdx;
    }

    public ParamFlowRule setParamIdx(Integer paramIdx) {
        this.paramIdx = paramIdx;
        return this;
    }

    public double getCount() {
        return this.count;
    }

    public ParamFlowRule setCount(double count) {
        this.count = count;
        return this;
    }

    public List<ParamFlowItem> getParamFlowItemList() {
        return this.paramFlowItemList;
    }

    public ParamFlowRule setParamFlowItemList(List<ParamFlowItem> paramFlowItemList) {
        this.paramFlowItemList = paramFlowItemList;
        return this;
    }

    public Integer retrieveExclusiveItemCount(Object value) {
        if (value == null || this.hotItems == null) {
            return null;
        }
        return this.hotItems.get(value);
    }

    Map<Object, Integer> getParsedHotItems() {
        return this.hotItems;
    }

    ParamFlowRule setParsedHotItems(Map<Object, Integer> hotItems) {
        this.hotItems = hotItems;
        return this;
    }

    public boolean isClusterMode() {
        return this.clusterMode;
    }

    public ParamFlowRule setClusterMode(boolean clusterMode) {
        this.clusterMode = clusterMode;
        return this;
    }

    public ParamFlowClusterConfig getClusterConfig() {
        return this.clusterConfig;
    }

    public ParamFlowRule setClusterConfig(ParamFlowClusterConfig clusterConfig) {
        this.clusterConfig = clusterConfig;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParamFlowRule that = (ParamFlowRule)o;
        if (this.grade != that.grade) {
            return false;
        }
        if (Double.compare(that.count, this.count) != 0) {
            return false;
        }
        if (this.controlBehavior != that.controlBehavior) {
            return false;
        }
        if (this.maxQueueingTimeMs != that.maxQueueingTimeMs) {
            return false;
        }
        if (this.burstCount != that.burstCount) {
            return false;
        }
        if (this.durationInSec != that.durationInSec) {
            return false;
        }
        if (this.clusterMode != that.clusterMode) {
            return false;
        }
        if (!Objects.equals(this.paramIdx, that.paramIdx)) {
            return false;
        }
        if (!Objects.equals(this.paramFlowItemList, that.paramFlowItemList)) {
            return false;
        }
        return Objects.equals(this.clusterConfig, that.clusterConfig);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.grade;
        result = 31 * result + (this.paramIdx != null ? this.paramIdx.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.count);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.controlBehavior;
        result = 31 * result + this.maxQueueingTimeMs;
        result = 31 * result + this.burstCount;
        result = 31 * result + (int)(this.durationInSec ^ this.durationInSec >>> 32);
        result = 31 * result + (this.paramFlowItemList != null ? this.paramFlowItemList.hashCode() : 0);
        result = 31 * result + (this.clusterMode ? 1 : 0);
        result = 31 * result + (this.clusterConfig != null ? this.clusterConfig.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ParamFlowRule{grade=" + this.grade + ", paramIdx=" + this.paramIdx + ", count=" + this.count + ", controlBehavior=" + this.controlBehavior + ", maxQueueingTimeMs=" + this.maxQueueingTimeMs + ", burstCount=" + this.burstCount + ", durationInSec=" + this.durationInSec + ", paramFlowItemList=" + this.paramFlowItemList + ", clusterMode=" + this.clusterMode + ", clusterConfig=" + this.clusterConfig + '}';
    }
}

