/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.util;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;

public final class VersionUtil {
    public static String getVersion(String defaultVersion) {
        try {
            String version = VersionUtil.class.getPackage().getImplementationVersion();
            return StringUtil.isBlank(version) ? defaultVersion : version;
        }
        catch (Throwable e) {
            RecordLog.warn("Using default version, ignore exception", e);
            return defaultVersion;
        }
    }

    private VersionUtil() {
    }

    private static int parseInt(String str) {
        char ch;
        if (str == null || str.length() < 1) {
            return 0;
        }
        int num = 0;
        for (int i2 = 0; i2 < str.length() && (ch = str.charAt(i2)) >= '0' && ch <= '9'; ++i2) {
            num = num * 10 + (ch - 48);
        }
        return num;
    }

    public static int fromVersionString(String verStr) {
        int pos;
        if (verStr == null || verStr.length() < 1) {
            return 0;
        }
        int[] versions = new int[]{0, 0, 0, 0};
        int index = 0;
        int cur = 0;
        do {
            String segment;
            if (index >= versions.length) {
                return 0;
            }
            pos = verStr.indexOf(46, cur);
            if (pos == -1) {
                segment = verStr.substring(cur);
            } else if (cur < pos) {
                segment = verStr.substring(cur, pos);
            } else {
                return 0;
            }
            versions[index] = VersionUtil.parseInt(segment);
            if (versions[index] < 0 || versions[index] > 255) {
                return 0;
            }
            cur = pos + 1;
            ++index;
        } while (pos > 0);
        return (versions[0] & 0xFF) << 24 | (versions[1] & 0xFF) << 16 | (versions[2] & 0xFF) << 8 | versions[3] & 0xFF;
    }
}

