/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

public class PrimitiveArraySerializer
implements ObjectSerializer {
    public static PrimitiveArraySerializer instance = new PrimitiveArraySerializer();

    public final void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        if (object instanceof int[]) {
            int[] array = (int[])object;
            out.write(91);
            for (int i2 = 0; i2 < array.length; ++i2) {
                if (i2 != 0) {
                    out.write(44);
                }
                out.writeInt(array[i2]);
            }
            out.write(93);
            return;
        }
        if (object instanceof short[]) {
            short[] array = (short[])object;
            out.write(91);
            for (int i3 = 0; i3 < array.length; ++i3) {
                if (i3 != 0) {
                    out.write(44);
                }
                out.writeInt(array[i3]);
            }
            out.write(93);
            return;
        }
        if (object instanceof long[]) {
            long[] array = (long[])object;
            out.write(91);
            for (int i4 = 0; i4 < array.length; ++i4) {
                if (i4 != 0) {
                    out.write(44);
                }
                out.writeLong(array[i4]);
            }
            out.write(93);
            return;
        }
        if (object instanceof boolean[]) {
            boolean[] array = (boolean[])object;
            out.write(91);
            for (int i5 = 0; i5 < array.length; ++i5) {
                if (i5 != 0) {
                    out.write(44);
                }
                out.write(array[i5]);
            }
            out.write(93);
            return;
        }
        if (object instanceof float[]) {
            float[] array = (float[])object;
            out.write(91);
            for (int i6 = 0; i6 < array.length; ++i6) {
                float item;
                if (i6 != 0) {
                    out.write(44);
                }
                if (Float.isNaN(item = array[i6])) {
                    out.writeNull();
                    continue;
                }
                out.append(Float.toString(item));
            }
            out.write(93);
            return;
        }
        if (object instanceof double[]) {
            double[] array = (double[])object;
            out.write(91);
            for (int i7 = 0; i7 < array.length; ++i7) {
                double item;
                if (i7 != 0) {
                    out.write(44);
                }
                if (Double.isNaN(item = array[i7])) {
                    out.writeNull();
                    continue;
                }
                out.append(Double.toString(item));
            }
            out.write(93);
            return;
        }
        if (object instanceof byte[]) {
            byte[] array = (byte[])object;
            out.writeByteArray(array);
            return;
        }
        char[] chars = (char[])object;
        out.writeString(chars);
    }
}

