/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.pojo;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ServiceInfo {
    @JsonIgnore
    private String jsonFromServer = "";
    public static final String SPLITER = "@@";
    private String name;
    private String groupName;
    private String clusters;
    private long cacheMillis = 1000L;
    private List<Instance> hosts = new ArrayList<Instance>();
    private long lastRefTime = 0L;
    private String checksum = "";
    private volatile boolean allIPs = false;
    private static final String EMPTY = "";
    private static final String ALL_IPS = "000--00-ALL_IPS--00--000";

    public ServiceInfo() {
    }

    public boolean isAllIPs() {
        return this.allIPs;
    }

    public void setAllIPs(boolean allIPs) {
        this.allIPs = allIPs;
    }

    public ServiceInfo(String key) {
        int maxIndex = 2;
        int clusterIndex = 2;
        int serviceNameIndex = 1;
        int groupIndex = 0;
        String[] keys2 = key.split(SPLITER);
        if (keys2.length >= maxIndex + 1) {
            this.groupName = keys2[groupIndex];
            this.name = keys2[serviceNameIndex];
            this.clusters = keys2[clusterIndex];
        } else if (keys2.length == maxIndex) {
            this.groupName = keys2[groupIndex];
            this.name = keys2[serviceNameIndex];
        } else {
            throw new IllegalArgumentException("Cann't parse out 'groupName',but it must not be null!");
        }
    }

    public ServiceInfo(String name, String clusters) {
        this.name = name;
        this.clusters = clusters;
    }

    public int ipCount() {
        return this.hosts.size();
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.lastRefTime > this.cacheMillis;
    }

    public void setHosts(List<Instance> hosts) {
        this.hosts = hosts;
    }

    public boolean isValid() {
        return this.hosts != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setLastRefTime(long lastRefTime) {
        this.lastRefTime = lastRefTime;
    }

    public long getLastRefTime() {
        return this.lastRefTime;
    }

    public String getClusters() {
        return this.clusters;
    }

    public void setClusters(String clusters) {
        this.clusters = clusters;
    }

    public long getCacheMillis() {
        return this.cacheMillis;
    }

    public void setCacheMillis(long cacheMillis) {
        this.cacheMillis = cacheMillis;
    }

    public List<Instance> getHosts() {
        return new ArrayList<Instance>(this.hosts);
    }

    public boolean validate() {
        if (this.isAllIPs()) {
            return true;
        }
        if (this.hosts == null) {
            return false;
        }
        ArrayList<Instance> validHosts = new ArrayList<Instance>();
        for (Instance host : this.hosts) {
            if (!host.isHealthy()) continue;
            int i2 = 0;
            while ((double)i2 < host.getWeight()) {
                validHosts.add(host);
                ++i2;
            }
        }
        return !validHosts.isEmpty();
    }

    @JsonIgnore
    public String getJsonFromServer() {
        return this.jsonFromServer;
    }

    public void setJsonFromServer(String jsonFromServer) {
        this.jsonFromServer = jsonFromServer;
    }

    @JsonIgnore
    public String getKey() {
        String serviceName = this.getGroupedServiceName();
        return ServiceInfo.getKey(serviceName, this.clusters);
    }

    @JsonIgnore
    public static String getKey(String name, String clusters) {
        if (!ServiceInfo.isEmpty(clusters)) {
            return name + SPLITER + clusters;
        }
        return name;
    }

    @JsonIgnore
    public String getKeyEncoded() {
        String serviceName = this.getGroupedServiceName();
        try {
            serviceName = URLEncoder.encode(serviceName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ServiceInfo.getKey(serviceName, this.clusters);
    }

    private String getGroupedServiceName() {
        String serviceName = this.name;
        if (!ServiceInfo.isEmpty(this.groupName) && serviceName.indexOf(SPLITER) == -1) {
            serviceName = this.groupName + SPLITER + serviceName;
        }
        return serviceName;
    }

    public static ServiceInfo fromKey(String key) {
        ServiceInfo serviceInfo = new ServiceInfo();
        int maxSegCount = 3;
        String[] segs = key.split(SPLITER);
        if (segs.length == maxSegCount - 1) {
            serviceInfo.setGroupName(segs[0]);
            serviceInfo.setName(segs[1]);
        } else if (segs.length == maxSegCount) {
            serviceInfo.setGroupName(segs[0]);
            serviceInfo.setName(segs[1]);
            serviceInfo.setClusters(segs[2]);
        }
        return serviceInfo;
    }

    public String toString() {
        return this.getKey();
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    private static boolean strEquals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }
}

