/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.client.config.impl.LocalConfigInfoProcessor;
import com.alibaba.nacos.client.config.utils.ConcurrentDiskUtil;
import com.alibaba.nacos.client.config.utils.JvmUtil;
import com.alibaba.nacos.client.config.utils.SnapShotSwitch;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.IoUtils;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;

public class LocalEncryptedDataKeyProcessor
extends LocalConfigInfoProcessor {
    private static final Logger LOGGER = LogUtils.logger(LocalEncryptedDataKeyProcessor.class);

    public static String getEncryptDataKeyFailover(String envName, String dataId, String group, String tenant) {
        File file = LocalEncryptedDataKeyProcessor.getEncryptDataKeyFailoverFile(envName, dataId, group, tenant);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            return LocalEncryptedDataKeyProcessor.readFile(file);
        }
        catch (IOException ioe) {
            LOGGER.error("[" + envName + "] get failover error, " + file, ioe);
            return null;
        }
    }

    public static String getEncryptDataKeySnapshot(String envName, String dataId, String group, String tenant) {
        if (!SnapShotSwitch.getIsSnapShot().booleanValue()) {
            return null;
        }
        File file = LocalEncryptedDataKeyProcessor.getEncryptDataKeySnapshotFile(envName, dataId, group, tenant);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            return LocalEncryptedDataKeyProcessor.readFile(file);
        }
        catch (IOException ioe) {
            LOGGER.error("[" + envName + "] get snapshot error, " + file, ioe);
            return null;
        }
    }

    public static void saveEncryptDataKeySnapshot(String envName, String dataId, String group, String tenant, String encryptDataKey) {
        if (!SnapShotSwitch.getIsSnapShot().booleanValue()) {
            return;
        }
        File file = LocalEncryptedDataKeyProcessor.getEncryptDataKeySnapshotFile(envName, dataId, group, tenant);
        try {
            if (null == encryptDataKey) {
                try {
                    IoUtils.delete(file);
                }
                catch (IOException ioe) {
                    LOGGER.error("[" + envName + "] delete snapshot error, " + file, ioe);
                }
            } else {
                boolean isMdOk;
                File parentFile = file.getParentFile();
                if (!parentFile.exists() && !(isMdOk = parentFile.mkdirs())) {
                    LOGGER.error("[{}] save snapshot error", (Object)envName);
                }
                if (JvmUtil.isMultiInstance().booleanValue()) {
                    ConcurrentDiskUtil.writeFileContent(file, encryptDataKey, "UTF-8");
                } else {
                    IoUtils.writeStringToFile(file, encryptDataKey, "UTF-8");
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.error("[" + envName + "] save snapshot error, " + file, ioe);
        }
    }

    private static File getEncryptDataKeyFailoverFile(String envName, String dataId, String group, String tenant) {
        File tmp = new File(LOCAL_SNAPSHOT_PATH, envName + "_nacos");
        tmp = new File(tmp, "encrypted-data-key");
        if (StringUtils.isBlank(tenant)) {
            tmp = new File(tmp, "failover");
        } else {
            tmp = new File(tmp, "failover-tenant");
            tmp = new File(tmp, tenant);
        }
        return new File(new File(tmp, group), dataId);
    }

    private static File getEncryptDataKeySnapshotFile(String envName, String dataId, String group, String tenant) {
        File tmp = new File(LOCAL_SNAPSHOT_PATH, envName + "_nacos");
        tmp = new File(tmp, "encrypted-data-key");
        if (StringUtils.isBlank(tenant)) {
            tmp = new File(tmp, "snapshot");
        } else {
            tmp = new File(tmp, "snapshot-tenant");
            tmp = new File(tmp, tenant);
        }
        return new File(new File(tmp, group), dataId);
    }
}

