/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.executor;

import com.alibaba.nacos.common.executor.ThreadPoolManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ExecutorFactory {
    public static ExecutorService newSingleExecutorService() {
        return Executors.newFixedThreadPool(1);
    }

    public static ExecutorService newSingleExecutorService(ThreadFactory threadFactory2) {
        return Executors.newFixedThreadPool(1, threadFactory2);
    }

    public static ExecutorService newFixedExecutorService(int nThreads) {
        return Executors.newFixedThreadPool(nThreads);
    }

    public static ExecutorService newFixedExecutorService(int nThreads, ThreadFactory threadFactory2) {
        return Executors.newFixedThreadPool(nThreads, threadFactory2);
    }

    public static ScheduledExecutorService newSingleScheduledExecutorService(ThreadFactory threadFactory2) {
        return Executors.newScheduledThreadPool(1, threadFactory2);
    }

    public static ScheduledExecutorService newScheduledExecutorService(int nThreads, ThreadFactory threadFactory2) {
        return Executors.newScheduledThreadPool(nThreads, threadFactory2);
    }

    public static ThreadPoolExecutor newCustomerThreadExecutor(int coreThreads, int maxThreads, long keepAliveTimeMs, ThreadFactory threadFactory2) {
        return new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTimeMs, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory2);
    }

    public static final class Managed {
        private static final String DEFAULT_NAMESPACE = "nacos";
        private static final ThreadPoolManager THREAD_POOL_MANAGER = ThreadPoolManager.getInstance();

        public static ExecutorService newSingleExecutorService(String group) {
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            THREAD_POOL_MANAGER.register(DEFAULT_NAMESPACE, group, executorService);
            return executorService;
        }

        public static ExecutorService newSingleExecutorService(String group, ThreadFactory threadFactory2) {
            ExecutorService executorService = Executors.newFixedThreadPool(1, threadFactory2);
            THREAD_POOL_MANAGER.register(DEFAULT_NAMESPACE, group, executorService);
            return executorService;
        }

        public static ExecutorService newFixedExecutorService(String group, int nThreads) {
            ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
            THREAD_POOL_MANAGER.register(DEFAULT_NAMESPACE, group, executorService);
            return executorService;
        }

        public static ExecutorService newFixedExecutorService(String group, int nThreads, ThreadFactory threadFactory2) {
            ExecutorService executorService = Executors.newFixedThreadPool(nThreads, threadFactory2);
            THREAD_POOL_MANAGER.register(DEFAULT_NAMESPACE, group, executorService);
            return executorService;
        }

        public static ScheduledExecutorService newSingleScheduledExecutorService(String group, ThreadFactory threadFactory2) {
            ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, threadFactory2);
            THREAD_POOL_MANAGER.register(DEFAULT_NAMESPACE, group, executorService);
            return executorService;
        }

        public static ScheduledExecutorService newScheduledExecutorService(String group, int nThreads, ThreadFactory threadFactory2) {
            ScheduledExecutorService executorService = Executors.newScheduledThreadPool(nThreads, threadFactory2);
            THREAD_POOL_MANAGER.register(DEFAULT_NAMESPACE, group, executorService);
            return executorService;
        }

        public static ThreadPoolExecutor newCustomerThreadExecutor(String group, int coreThreads, int maxThreads, long keepAliveTimeMs, ThreadFactory threadFactory2) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTimeMs, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory2);
            THREAD_POOL_MANAGER.register(DEFAULT_NAMESPACE, group, executor);
            return executor;
        }
    }
}

