/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client;

import com.alibaba.nacos.common.http.client.handler.BeanResponseHandler;
import com.alibaba.nacos.common.http.client.handler.ResponseHandler;
import com.alibaba.nacos.common.http.client.handler.RestResultResponseHandler;
import com.alibaba.nacos.common.http.client.handler.StringResponseHandler;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.fasterxml.jackson.databind.JavaType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public abstract class AbstractNacosRestTemplate {
    private final Map<String, ResponseHandler> responseHandlerMap = new HashMap<String, ResponseHandler>();
    protected final Logger logger;

    public AbstractNacosRestTemplate(Logger logger2) {
        this.logger = logger2;
        this.initDefaultResponseHandler();
    }

    private void initDefaultResponseHandler() {
        this.responseHandlerMap.put("java.lang.String", new StringResponseHandler());
        this.responseHandlerMap.put("com.alibaba.nacos.common.model.RestResult", new RestResultResponseHandler());
        this.responseHandlerMap.put("default_bean_handler", new BeanResponseHandler());
    }

    public void registerResponseHandler(String responseHandlerType, ResponseHandler responseHandler) {
        this.responseHandlerMap.put(responseHandlerType, responseHandler);
    }

    protected ResponseHandler selectResponseHandler(Type responseType) {
        ResponseHandler responseHandler = null;
        if (responseType == null) {
            responseHandler = this.responseHandlerMap.get("java.lang.String");
        }
        if (responseHandler == null) {
            JavaType javaType = JacksonUtils.constructJavaType(responseType);
            String name = javaType.getRawClass().getName();
            responseHandler = this.responseHandlerMap.get(name);
        }
        if (responseHandler == null) {
            responseHandler = this.responseHandlerMap.get("default_bean_handler");
        }
        responseHandler.setResponseType(responseType);
        return responseHandler;
    }
}

